/*
 * Decompiled with CFR 0.152.
 */
package com.c4_soft.springaddons.security.oauth2.config.synchronised;

import com.c4_soft.springaddons.security.oauth2.OAuthentication;
import com.c4_soft.springaddons.security.oauth2.OpenidClaimSet;
import com.c4_soft.springaddons.security.oauth2.SynchronizedJwt2AuthenticationConverter;
import com.c4_soft.springaddons.security.oauth2.SynchronizedJwt2OAuthenticationConverter;
import com.c4_soft.springaddons.security.oauth2.SynchronizedJwt2OpenidClaimSetConverter;
import com.c4_soft.springaddons.security.oauth2.config.ConfigurableJwtGrantedAuthoritiesConverter;
import com.c4_soft.springaddons.security.oauth2.config.Jwt2AuthoritiesConverter;
import com.c4_soft.springaddons.security.oauth2.config.SpringAddonsSecurityProperties;
import com.c4_soft.springaddons.security.oauth2.config.synchronised.ExpressionInterceptUrlRegistryPostProcessor;
import com.c4_soft.springaddons.security.oauth2.config.synchronised.HttpSecurityPostProcessor;
import java.io.Serializable;
import java.util.Arrays;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.Set;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import javax.servlet.http.HttpServletRequest;
import lombok.Generated;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.boot.autoconfigure.AutoConfiguration;
import org.springframework.boot.autoconfigure.condition.ConditionalOnMissingBean;
import org.springframework.boot.autoconfigure.security.oauth2.resource.OAuth2ResourceServerProperties;
import org.springframework.boot.autoconfigure.web.ServerProperties;
import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.Import;
import org.springframework.core.convert.converter.Converter;
import org.springframework.http.HttpStatus;
import org.springframework.security.authentication.AbstractAuthenticationToken;
import org.springframework.security.authentication.AuthenticationManager;
import org.springframework.security.authentication.AuthenticationManagerResolver;
import org.springframework.security.config.annotation.web.builders.HttpSecurity;
import org.springframework.security.config.annotation.web.configuration.EnableWebSecurity;
import org.springframework.security.config.annotation.web.configurers.ChannelSecurityConfigurer;
import org.springframework.security.config.annotation.web.configurers.ExpressionUrlAuthorizationConfigurer;
import org.springframework.security.config.http.SessionCreationPolicy;
import org.springframework.security.oauth2.jwt.Jwt;
import org.springframework.security.oauth2.jwt.JwtDecoder;
import org.springframework.security.oauth2.jwt.JwtDecoders;
import org.springframework.security.oauth2.jwt.SupplierJwtDecoder;
import org.springframework.security.oauth2.server.resource.authentication.JwtAuthenticationProvider;
import org.springframework.security.oauth2.server.resource.authentication.JwtIssuerAuthenticationManagerResolver;
import org.springframework.security.web.SecurityFilterChain;
import org.springframework.util.StringUtils;
import org.springframework.web.cors.CorsConfiguration;
import org.springframework.web.cors.CorsConfigurationSource;
import org.springframework.web.cors.UrlBasedCorsConfigurationSource;

@AutoConfiguration
@Import(value={SpringAddonsSecurityProperties.class})
@EnableWebSecurity
public class ServletSecurityBeans {
    @Generated
    private static final Logger log = LoggerFactory.getLogger(ServletSecurityBeans.class);

    @ConditionalOnMissingBean
    @Bean
    SecurityFilterChain filterChain(HttpSecurity http, AuthenticationManagerResolver<HttpServletRequest> authenticationManagerResolver, ExpressionInterceptUrlRegistryPostProcessor expressionInterceptUrlRegistryPostProcessor, HttpSecurityPostProcessor httpSecurityPostProcessor, ServerProperties serverProperties, SpringAddonsSecurityProperties securityProperties) throws Exception {
        http.oauth2ResourceServer(oauth2 -> oauth2.authenticationManagerResolver(authenticationManagerResolver));
        if (securityProperties.isAnonymousEnabled()) {
            http.anonymous();
        }
        if (securityProperties.getCors().length > 0) {
            http.cors().configurationSource(this.corsConfigurationSource(securityProperties));
        }
        if (!securityProperties.isCsrfEnabled()) {
            http.csrf().disable();
        }
        if (securityProperties.isStatlessSessions()) {
            http.sessionManagement().sessionCreationPolicy(SessionCreationPolicy.STATELESS);
        }
        if (!securityProperties.isRedirectToLoginIfUnauthorizedOnRestrictedContent()) {
            http.exceptionHandling().authenticationEntryPoint((request, response, authException) -> {
                response.addHeader("WWW-Authenticate", "Basic realm=\"Restricted Content\"");
                response.sendError(HttpStatus.UNAUTHORIZED.value(), HttpStatus.UNAUTHORIZED.getReasonPhrase());
            });
        }
        if (serverProperties.getSsl() != null && serverProperties.getSsl().isEnabled()) {
            ((ChannelSecurityConfigurer.RequiresChannelUrl)http.requiresChannel().anyRequest()).requiresSecure();
        } else {
            ((ChannelSecurityConfigurer.RequiresChannelUrl)http.requiresChannel().anyRequest()).requiresInsecure();
        }
        expressionInterceptUrlRegistryPostProcessor.authorizeRequests(((ExpressionUrlAuthorizationConfigurer.AuthorizedUrl)http.authorizeRequests().antMatchers(securityProperties.getPermitAll())).permitAll());
        return (SecurityFilterChain)httpSecurityPostProcessor.process(http).build();
    }

    @ConditionalOnMissingBean
    @Bean
    ExpressionInterceptUrlRegistryPostProcessor expressionInterceptUrlRegistryPostProcessor(SpringAddonsSecurityProperties securityProperties) {
        return registry -> ((ExpressionUrlAuthorizationConfigurer.AuthorizedUrl)registry.anyRequest()).authenticated();
    }

    @ConditionalOnMissingBean
    @Bean
    HttpSecurityPostProcessor httpSecurityPostProcessor() {
        return httpSecurity -> httpSecurity;
    }

    @ConditionalOnMissingBean
    @Bean
    <T extends Map<String, Object> & Serializable> SynchronizedJwt2AuthenticationConverter<OAuthentication<T>> authenticationConverter(Jwt2AuthoritiesConverter authoritiesConverter, SynchronizedJwt2OpenidClaimSetConverter<T> claimsConverter) {
        log.debug("Building default SynchronizedJwt2OAuthenticationConverter");
        return new SynchronizedJwt2OAuthenticationConverter<T>(authoritiesConverter, claimsConverter);
    }

    @ConditionalOnMissingBean
    @Bean
    Jwt2AuthoritiesConverter authoritiesConverter(SpringAddonsSecurityProperties securityProperties) {
        log.debug("Building default SimpleJwtGrantedAuthoritiesConverter with: {}", (Object)securityProperties);
        return new ConfigurableJwtGrantedAuthoritiesConverter(securityProperties);
    }

    @ConditionalOnMissingBean
    @Bean
    SynchronizedJwt2OpenidClaimSetConverter<OpenidClaimSet> claimsConverter() {
        log.debug("Building default SynchronizedJwt2OpenidClaimSetConverter");
        return jwt -> new OpenidClaimSet(jwt.getClaims());
    }

    @ConditionalOnMissingBean
    @Bean
    JwtIssuerAuthenticationManagerResolver authenticationManagerResolver(OAuth2ResourceServerProperties auth2ResourceServerProperties, SpringAddonsSecurityProperties securityProperties, Converter<Jwt, ? extends AbstractAuthenticationToken> authenticationConverter) {
        Set locations = Stream.concat(Optional.of(auth2ResourceServerProperties.getJwt()).map(OAuth2ResourceServerProperties.Jwt::getIssuerUri).stream(), Stream.of(securityProperties.getTokenIssuers()).map(SpringAddonsSecurityProperties.TokenIssuerProperties::getLocation)).filter(Objects::nonNull).map(Object::toString).filter(StringUtils::hasLength).collect(Collectors.toSet());
        Map<String, AuthenticationManager> managers = locations.stream().collect(Collectors.toMap(l -> l, l -> {
            SupplierJwtDecoder decoder = new SupplierJwtDecoder(() -> JwtDecoders.fromIssuerLocation((String)l));
            JwtAuthenticationProvider provider = new JwtAuthenticationProvider((JwtDecoder)decoder);
            provider.setJwtAuthenticationConverter(authenticationConverter);
            return arg_0 -> ((JwtAuthenticationProvider)provider).authenticate(arg_0);
        }));
        log.debug("Building default JwtIssuerAuthenticationManagerResolver with: ", (Object)auth2ResourceServerProperties.getJwt(), Stream.of(securityProperties.getTokenIssuers()).toList());
        return new JwtIssuerAuthenticationManagerResolver(managers::get);
    }

    private CorsConfigurationSource corsConfigurationSource(SpringAddonsSecurityProperties securityProperties) {
        log.debug("Building default CorsConfigurationSource with: {}", Stream.of(securityProperties.getCors()).toList());
        UrlBasedCorsConfigurationSource source = new UrlBasedCorsConfigurationSource();
        for (SpringAddonsSecurityProperties.CorsProperties corsProps : securityProperties.getCors()) {
            CorsConfiguration configuration = new CorsConfiguration();
            configuration.setAllowedOrigins(Arrays.asList(corsProps.getAllowedOrigins()));
            configuration.setAllowedMethods(Arrays.asList(corsProps.getAllowedMethods()));
            configuration.setAllowedHeaders(Arrays.asList(corsProps.getAllowedHeaders()));
            configuration.setExposedHeaders(Arrays.asList(corsProps.getExposedHeaders()));
            source.registerCorsConfiguration(corsProps.getPath(), configuration);
        }
        return source;
    }
}

