/*
 * Decompiled with CFR 0.152.
 */
package com.c4_soft.springaddons.test.support.web;

import com.c4_soft.springaddons.test.support.web.ByteArrayHttpOutputMessage;
import java.io.IOException;
import java.util.List;
import java.util.stream.Collectors;
import org.springframework.beans.factory.ObjectFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.boot.autoconfigure.http.HttpMessageConverters;
import org.springframework.boot.test.context.TestComponent;
import org.springframework.http.HttpOutputMessage;
import org.springframework.http.MediaType;
import org.springframework.http.converter.HttpMessageConverter;

@TestComponent
public class SerializationHelper {
    private final ObjectFactory<HttpMessageConverters> messageConverters;

    @Autowired
    public SerializationHelper(ObjectFactory<HttpMessageConverters> messageConverters) {
        this.messageConverters = messageConverters;
    }

    public <T> ByteArrayHttpOutputMessage outputMessage(T payload, MediaType mediaType) throws Exception {
        if (payload == null) {
            return null;
        }
        List relevantConverters = ((HttpMessageConverters)this.messageConverters.getObject()).getConverters().stream().filter(converter -> converter.canWrite(payload.getClass(), mediaType)).map(c -> c).collect(Collectors.toList());
        ByteArrayHttpOutputMessage converted = new ByteArrayHttpOutputMessage();
        boolean isConverted = false;
        for (HttpMessageConverter converter2 : relevantConverters) {
            try {
                converted.headers.setContentType(mediaType);
                converter2.write(payload, mediaType, (HttpOutputMessage)converted);
                isConverted = true;
                break;
            }
            catch (IOException iOException) {
            }
        }
        if (!isConverted) {
            throw new Exception("Could not convert " + payload.getClass() + " to " + mediaType.toString());
        }
        return converted;
    }

    public <T> String asString(T payload, MediaType mediaType) throws Exception {
        return payload == null ? null : this.outputMessage(payload, (MediaType)mediaType).out.toString();
    }

    public <T> String asJsonString(T payload) throws Exception {
        return this.asString(payload, MediaType.APPLICATION_JSON);
    }

    public <T> String asXmlnString(T payload) throws Exception {
        return this.asString(payload, MediaType.APPLICATION_XML);
    }
}

