/*
 * Decompiled with CFR 0.152.
 */
package com.caffinc.jaggr.core;

import com.caffinc.jaggr.core.operations.Operation;
import com.caffinc.jaggr.core.utils.FieldValueExtractor;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;

public class Aggregation {
    private String _id;
    private String[] idSplit;
    private Map<String, Operation> operationMap;

    Aggregation(String _id, Map<String, Operation> operationMap) {
        this._id = _id;
        this.idSplit = _id != null ? _id.split("\\.") : null;
        this.operationMap = operationMap;
    }

    public List<Map<String, Object>> aggregate(final Iterator<Map<String, Object>> objectIterator) {
        return this.aggregate(new Iterable<Map<String, Object>>(){

            @Override
            public Iterator<Map<String, Object>> iterator() {
                return objectIterator;
            }
        });
    }

    public List<Map<String, Object>> aggregate(Iterable<Map<String, Object>> objectList) {
        HashMap<String, Map<String, Object>> workspace = new HashMap<String, Map<String, Object>>();
        if (objectList != null) {
            for (Map<String, Object> object : objectList) {
                this.aggregate(object, workspace);
            }
        }
        return this.computeResults(workspace);
    }

    private void aggregate(Map<String, Object> object, Map<String, Map<String, Object>> workspace) {
        Map<Object, Object> groupWorkspace;
        String id = "0";
        if (this._id != null) {
            id = String.valueOf(FieldValueExtractor.getValue(this.idSplit, object));
        }
        if (!workspace.containsKey(id)) {
            groupWorkspace = new HashMap<String, String>();
            groupWorkspace.put("_id", id);
            workspace.put(id, groupWorkspace);
        }
        groupWorkspace = workspace.get(id);
        for (Map.Entry<String, Operation> operationEntry : this.operationMap.entrySet()) {
            String field = operationEntry.getKey();
            Operation operation = operationEntry.getValue();
            Object t0 = groupWorkspace.get(field);
            Object t1 = operation.aggregate(t0, object);
            groupWorkspace.put(field, t1);
        }
    }

    private List<Map<String, Object>> computeResults(Map<String, Map<String, Object>> workspace) {
        ArrayList<Map<String, Object>> resultList = new ArrayList<Map<String, Object>>();
        for (Map<String, Object> groupWorkspace : workspace.values()) {
            for (Map.Entry<String, Operation> operationEntry : this.operationMap.entrySet()) {
                String field = operationEntry.getKey();
                Operation operation = operationEntry.getValue();
                groupWorkspace.put(field, operation.result(groupWorkspace.get(field)));
            }
            resultList.add(groupWorkspace);
        }
        return resultList;
    }
}

