/*
 * Decompiled with CFR 0.152.
 */
package com.caffinc.jaggr.core;

import com.caffinc.jaggr.core.operations.Operation;
import com.caffinc.jaggr.core.utils.FieldValueExtractor;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;

public class BatchAggregation {
    private String _id;
    private String[] idSplit;
    private Map<String, Operation> operationMap;
    private Map<String, Map<String, Object>> workspace;

    BatchAggregation(String _id, Map<String, Operation> operationMap) {
        this._id = _id;
        this.idSplit = _id != null ? _id.split("\\.") : null;
        this.operationMap = operationMap;
        this.workspace = new HashMap<String, Map<String, Object>>();
    }

    public BatchAggregation aggregateBatch(final Iterator<Map<String, Object>> objectIterator) {
        this.aggregateBatch(new Iterable<Map<String, Object>>(){

            @Override
            public Iterator<Map<String, Object>> iterator() {
                return objectIterator;
            }
        });
        return this;
    }

    public BatchAggregation aggregateBatch(Iterable<Map<String, Object>> objectList) {
        if (objectList != null) {
            for (Map<String, Object> object : objectList) {
                this.aggregate(object, this.workspace);
            }
        }
        return this;
    }

    private void aggregate(Map<String, Object> object, Map<String, Map<String, Object>> workspace) {
        Map<Object, Object> groupWorkspace;
        String id = "0";
        if (this._id != null) {
            id = String.valueOf(FieldValueExtractor.getValue(this.idSplit, object));
        }
        if (!workspace.containsKey(id)) {
            groupWorkspace = new HashMap<String, String>();
            groupWorkspace.put("_id", id);
            workspace.put(id, groupWorkspace);
        }
        groupWorkspace = workspace.get(id);
        for (Map.Entry<String, Operation> operationEntry : this.operationMap.entrySet()) {
            String field = operationEntry.getKey();
            Operation operation = operationEntry.getValue();
            Object t0 = groupWorkspace.get(field);
            Object t1 = operation.aggregate(t0, object);
            groupWorkspace.put(field, t1);
        }
    }

    public List<Map<String, Object>> getItermediateResult() {
        return this.computeIntermediateResults(this.workspace);
    }

    public List<Map<String, Object>> getFinalResult() {
        List<Map<String, Object>> result = this.computeFinalResults(this.workspace);
        this.workspace = new HashMap<String, Map<String, Object>>();
        return result;
    }

    private List<Map<String, Object>> computeFinalResults(Map<String, Map<String, Object>> workspace) {
        ArrayList<Map<String, Object>> resultList = new ArrayList<Map<String, Object>>();
        for (Map<String, Object> groupWorkspace : workspace.values()) {
            for (Map.Entry<String, Operation> operationEntry : this.operationMap.entrySet()) {
                String field = operationEntry.getKey();
                Operation operation = operationEntry.getValue();
                groupWorkspace.put(field, operation.result(groupWorkspace.get(field)));
            }
            resultList.add(groupWorkspace);
        }
        return resultList;
    }

    private List<Map<String, Object>> computeIntermediateResults(Map<String, Map<String, Object>> workspace) {
        ArrayList<Map<String, Object>> resultList = new ArrayList<Map<String, Object>>();
        for (Map<String, Object> groupWorkspace : workspace.values()) {
            HashMap<String, Object> intermediateResult = new HashMap<String, Object>(groupWorkspace);
            for (Map.Entry<String, Operation> operationEntry : this.operationMap.entrySet()) {
                String field = operationEntry.getKey();
                Operation operation = operationEntry.getValue();
                intermediateResult.put(field, operation.result(groupWorkspace.get(field)));
            }
            resultList.add(intermediateResult);
        }
        return resultList;
    }
}

