/*
 * Decompiled with CFR 0.152.
 */
package com.caffinc.jaggr.core.operations;

import com.caffinc.jaggr.core.entities.Tuple2;
import com.caffinc.jaggr.core.operations.Operation;
import com.caffinc.jaggr.core.utils.FieldValueExtractor;
import java.util.Map;

public class AverageOperation
implements Operation {
    private String[] field;
    private String unsplitField;

    public AverageOperation(String field) {
        this.unsplitField = field;
        this.field = field.split("\\.");
    }

    @Override
    public Object aggregate(Object previousAccumulatedValue, Map<String, Object> object) {
        Tuple2<Double, Integer> accumulator;
        Object value = FieldValueExtractor.getValue(this.field, object);
        if (value == null) {
            return previousAccumulatedValue;
        }
        Tuple2<Double, Integer> tuple2 = accumulator = previousAccumulatedValue == null ? new Tuple2<Double, Integer>(0.0, 0) : (Tuple2)previousAccumulatedValue;
        if (value instanceof Double) {
            accumulator._1 = (Double)accumulator._1 + (Double)value;
        } else if (value instanceof Float) {
            accumulator._1 = (Double)accumulator._1 + (double)((Float)value).floatValue();
        } else if (value instanceof Long) {
            accumulator._1 = (Double)accumulator._1 + (double)((Long)value).longValue();
        } else if (value instanceof Integer) {
            accumulator._1 = (Double)accumulator._1 + (double)((Integer)value).intValue();
        } else {
            throw new IllegalArgumentException("Field " + this.unsplitField + " isn't a Double, Float, Long or Integer");
        }
        Tuple2<Double, Integer> tuple22 = accumulator;
        Integer n = (Integer)tuple22._2;
        tuple22._2 = (Integer)tuple22._2 + 1;
        Integer n2 = tuple22._2;
        return accumulator;
    }

    @Override
    public Object result(Object accumulatedValue) {
        Tuple2<Double, Integer> accumulator = accumulatedValue == null ? new Tuple2<Double, Integer>(0.0, 1) : (Tuple2)accumulatedValue;
        return (Double)accumulator._1 / (double)((Integer)accumulator._2).intValue();
    }
}

