/*
 * Decompiled with CFR 0.152.
 */
package com.caffinc.jaggr.core.operations;

import com.caffinc.jaggr.core.operations.Operation;
import com.caffinc.jaggr.core.utils.FieldValueExtractor;
import java.util.Map;

public class MaxOperation
implements Operation {
    private String[] field;
    private String unsplitField;
    private boolean isDouble = false;

    public MaxOperation(String field) {
        this.unsplitField = field;
        this.field = field.split("\\.");
    }

    @Override
    public Object aggregate(Object previousAccumulatedValue, Map<String, Object> object) {
        Object value = FieldValueExtractor.getValue(this.field, object);
        if (value == null) {
            return previousAccumulatedValue;
        }
        Double accumulator = previousAccumulatedValue == null ? Double.MIN_VALUE : (Double)previousAccumulatedValue;
        if (value instanceof Double) {
            this.isDouble = true;
            return accumulator < (Double)value ? value : accumulator;
        }
        if (value instanceof Float) {
            this.isDouble = true;
            return accumulator < (double)((Float)value).floatValue() ? value : accumulator;
        }
        if (value instanceof Long) {
            return accumulator < (double)((Long)value).longValue() ? value : accumulator;
        }
        if (value instanceof Integer) {
            return accumulator < (double)((Integer)value).intValue() ? value : accumulator;
        }
        throw new IllegalArgumentException("Field " + this.unsplitField + " isn't a Double, Float, Long or Integer");
    }

    @Override
    public Object result(Object accumulatedValue) {
        if (accumulatedValue != null) {
            return this.isDouble ? accumulatedValue : Long.valueOf(((Double)accumulatedValue).longValue());
        }
        return null;
    }
}

