/*
 * Decompiled with CFR 0.152.
 */
package com.caffinc.jaggr.core.operations;

import com.caffinc.jaggr.core.entities.Tuple3;
import com.caffinc.jaggr.core.operations.Operation;
import com.caffinc.jaggr.core.utils.FieldValueExtractor;
import java.util.Map;

public class StdDevPopOperation
implements Operation {
    private String[] field;
    private String unsplitField;

    public StdDevPopOperation(String field) {
        this.unsplitField = field;
        this.field = field.split("\\.");
    }

    @Override
    public Object aggregate(Object previousAccumulatedValue, Map<String, Object> object) {
        Object value = FieldValueExtractor.getValue(this.field, object);
        if (value == null) {
            return previousAccumulatedValue;
        }
        Tuple3<Double, Double, Integer> accumulator = previousAccumulatedValue == null ? new Tuple3<Double, Double, Integer>(0.0, 0.0, 0) : (Tuple3)previousAccumulatedValue;
        Double parsedValue = 0.0;
        if (value instanceof Double) {
            parsedValue = (Double)value;
        } else if (value instanceof Float) {
            parsedValue = parsedValue + (double)((Float)value).floatValue();
        } else if (value instanceof Long) {
            parsedValue = parsedValue + (double)((Long)value).longValue();
        } else if (value instanceof Integer) {
            parsedValue = parsedValue + (double)((Integer)value).intValue();
        } else {
            throw new IllegalArgumentException("Field " + this.unsplitField + " isn't a Double, Float, Long or Integer");
        }
        Tuple3<Double, Double, Integer> tuple3 = accumulator;
        Integer n = (Integer)tuple3._3;
        tuple3._3 = (Integer)tuple3._3 + 1;
        Tuple3<Double, Double, Integer> tuple32 = tuple3._3;
        double tmpM = (Double)accumulator._1;
        tuple32 = accumulator;
        tuple32._1 = (Double)tuple32._1 + (parsedValue - tmpM) / (double)((Integer)accumulator._3).intValue();
        tuple32 = accumulator;
        tuple32._2 = (Double)tuple32._2 + (parsedValue - tmpM) * (parsedValue - (Double)accumulator._1);
        return accumulator;
    }

    @Override
    public Object result(Object accumulatedValue) {
        Tuple3 accumulator;
        Tuple3 tuple3 = accumulator = accumulatedValue == null ? null : (Tuple3)accumulatedValue;
        if (accumulator == null || (Integer)accumulator._3 == 1 || (Double)accumulator._2 < 0.0) {
            return null;
        }
        return Math.sqrt((Double)accumulator._2 / (double)((Integer)accumulator._3 - 1));
    }
}

