/*
 * Decompiled with CFR 0.152.
 */
package com.caffinc.jaggr.core.operations;

import com.caffinc.jaggr.core.operations.Operation;
import com.caffinc.jaggr.core.utils.FieldValueExtractor;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Comparator;
import java.util.Map;
import java.util.PriorityQueue;

public class TopNOperation<T>
implements Operation {
    private String[] field;
    private String unsplitField;
    private int n;
    private Comparator<T> comparator;

    public TopNOperation(String field, int n, Comparator<T> comparator) {
        this.unsplitField = field;
        this.field = field.split("\\.");
        this.n = n;
        this.comparator = comparator;
    }

    @Override
    public Object aggregate(Object previousAccumulatedValue, Map<String, Object> object) {
        Object value = FieldValueExtractor.getValue(this.field, object);
        if (value == null) {
            return null;
        }
        PriorityQueue<T> priorityQueue = previousAccumulatedValue == null ? new PriorityQueue<T>(this.n, this.comparator) : (PriorityQueue)previousAccumulatedValue;
        priorityQueue.add(value);
        if (priorityQueue.size() > this.n) {
            priorityQueue.poll();
        }
        return priorityQueue;
    }

    @Override
    public Object result(Object accumulatedValue) {
        if (accumulatedValue == null) {
            return null;
        }
        return new ArrayList((Collection)accumulatedValue);
    }
}

