/*
 * Decompiled with CFR 0.152.
 */
package com.calincosma.argsparser;

import com.calincosma.argsparser.Arg;
import com.calincosma.argsparser.ArgsParserException;
import java.io.File;
import java.lang.reflect.Array;
import java.lang.reflect.Field;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.lang.reflect.Modifier;
import java.lang.reflect.ParameterizedType;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.NavigableMap;
import java.util.Queue;
import java.util.Set;
import java.util.SortedMap;
import java.util.TreeMap;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentMap;
import java.util.concurrent.ConcurrentNavigableMap;
import java.util.concurrent.ConcurrentSkipListMap;
import java.util.stream.Collectors;

public class Parser {
    public static Parser getInstance() {
        return new Parser();
    }

    private Parser() {
    }

    public <ARGS> ARGS parse(String[] argsArray, Class<ARGS> clazz) throws ArgsParserException {
        try {
            ARGS args = clazz.newInstance();
            HashMap<String, Field> options = new HashMap<String, Field>();
            HashSet<Field> requiredFields = new HashSet<Field>();
            HashSet<Field> treatedFields = new HashSet<Field>();
            Field currentField = null;
            for (Field field2 : clazz.getDeclaredFields()) {
                Arg annotation = field2.getAnnotation(Arg.class);
                if (annotation == null) continue;
                if (annotation.value() != null && annotation.value().length() > 0) {
                    options.put(annotation.value(), field2);
                }
                if (!annotation.required()) continue;
                requiredFields.add(field2);
            }
            LinkedList argsList = new LinkedList();
            Collections.addAll(argsList, argsArray);
            ArrayList<String> currentValues = new ArrayList<String>();
            while (!argsList.isEmpty()) {
                if (options.get(argsList.getFirst()) != null) {
                    currentField = (Field)options.get(argsList.pop());
                    currentField.setAccessible(true);
                }
                while (!argsList.isEmpty() && options.get(argsList.getFirst()) == null) {
                    currentValues.add((String)argsList.pop());
                }
                this.setValues(args, currentField, currentValues);
                requiredFields.remove(currentField);
                treatedFields.add(currentField);
                currentField = null;
                currentValues.clear();
            }
            if (requiredFields.size() > 0) {
                String requiredFieldsNames = requiredFields.stream().map(field -> field.getAnnotation(Arg.class)).filter(a -> a.value() != null).map(a -> a.value()).collect(Collectors.joining(","));
                throw new ArgsParserException("Missing values for required arguments " + requiredFieldsNames);
            }
            return args;
        }
        catch (Exception e) {
            throw new ArgsParserException(e);
        }
    }

    private <ARGS> void setValues(ARGS args, Field field, List<String> values) throws IllegalAccessException, InstantiationException {
        Class<?> fieldType = field.getType();
        if (Collection.class.isAssignableFrom(fieldType)) {
            if (fieldType.isInterface()) {
                if (List.class.isAssignableFrom(fieldType)) {
                    field.set(args, new ArrayList());
                } else if (Set.class.isAssignableFrom(fieldType)) {
                    field.set(args, new HashSet());
                } else if (Queue.class.isAssignableFrom(fieldType)) {
                    field.set(args, new LinkedList());
                }
            } else {
                field.set(args, fieldType.newInstance());
            }
            ParameterizedType parameterizedType = (ParameterizedType)field.getGenericType();
            Class collectionType = (Class)parameterizedType.getActualTypeArguments()[0];
            for (String value : values) {
                ((Collection)field.get(args)).add(this.getValue(value, collectionType));
            }
        } else if (Map.class.isAssignableFrom(fieldType)) {
            if (fieldType.isInterface()) {
                if (ConcurrentMap.class.isAssignableFrom(fieldType)) {
                    field.set(args, new ConcurrentHashMap());
                } else if (NavigableMap.class.isAssignableFrom(fieldType) || SortedMap.class.isAssignableFrom(fieldType)) {
                    field.set(args, new TreeMap());
                } else if (ConcurrentNavigableMap.class.isAssignableFrom(fieldType)) {
                    field.set(args, new ConcurrentSkipListMap());
                } else {
                    field.set(args, new HashMap());
                }
            } else {
                field.set(args, fieldType.newInstance());
            }
            ParameterizedType parameterizedType = (ParameterizedType)field.getGenericType();
            Class keyType = (Class)parameterizedType.getActualTypeArguments()[0];
            Class valueType = (Class)parameterizedType.getActualTypeArguments()[1];
            for (String value : values) {
                String mapKey = value.substring(0, value.indexOf("="));
                String mapValue = value.substring(value.indexOf("=") + 1);
                ((Map)field.get(args)).put(this.getValue(mapKey, keyType), this.getValue(mapValue, valueType));
            }
        } else if (fieldType.isArray()) {
            Class<?> arrayType = fieldType.getComponentType();
            this.createArray(args, field, values, arrayType);
        } else if (values.size() == 1) {
            field.set(args, this.getValue(values.get(0), fieldType));
        }
    }

    private <ARGS, VALUE> VALUE getValue(String arg, Class<VALUE> fieldType) {
        try {
            if (String.class == fieldType) {
                return (VALUE)arg;
            }
            Method method = null;
            try {
                method = fieldType.getMethod("valueOf", String.class);
            }
            catch (Exception e) {
                // empty catch block
            }
            if (method != null && method.getReturnType() == fieldType && Modifier.isStatic(method.getModifiers())) {
                return fieldType.cast(method.invoke(null, arg));
            }
            if (Integer.class == fieldType || Integer.TYPE == fieldType) {
                return (VALUE)Integer.valueOf(arg);
            }
            if (Long.class == fieldType || Long.TYPE == fieldType) {
                return (VALUE)Long.valueOf(arg);
            }
            if (Double.class == fieldType || Double.TYPE == fieldType) {
                return (VALUE)Double.valueOf(arg);
            }
            if (Float.class == fieldType || Float.TYPE == fieldType) {
                return (VALUE)Float.valueOf(arg);
            }
            if (Short.class == fieldType || Short.TYPE == fieldType) {
                return (VALUE)Short.valueOf(arg);
            }
            if (Boolean.class == fieldType || Boolean.TYPE == fieldType) {
                return (VALUE)Boolean.valueOf(arg);
            }
            if (File.class == fieldType) {
                return (VALUE)new File(arg);
            }
            if (Path.class == fieldType) {
                return (VALUE)Paths.get(arg, new String[0]);
            }
            return null;
        }
        catch (IllegalAccessException | IllegalArgumentException | InvocationTargetException e) {
            throw new ArgsParserException(e);
        }
    }

    private <ARGS, ArrayType> void createArray(ARGS args, Field field, List<String> values, Class<ArrayType> arrayTypeClass) throws IllegalAccessException {
        Object array = Array.newInstance(arrayTypeClass, values.size());
        int i = 0;
        for (String value : values) {
            Array.set(array, i++, this.getValue(value, arrayTypeClass));
        }
        field.set(args, array);
    }
}

