/*
 * Decompiled with CFR 0.152.
 */
package com.callibrity.logging.test;

import ch.qos.logback.classic.Level;
import ch.qos.logback.classic.Logger;
import ch.qos.logback.classic.LoggerContext;
import ch.qos.logback.classic.spi.ILoggingEvent;
import ch.qos.logback.core.read.ListAppender;
import java.util.List;
import java.util.Vector;
import org.slf4j.LoggerFactory;

public class LogTracker {
    private final ListAppender<ILoggingEvent> listAppender = new ListAppender();
    private final LoggerContext loggerContext = (LoggerContext)LoggerFactory.getILoggerFactory();
    private final Vector<Class<?>> loggingSources = new Vector();
    private LogLevel level = LogLevel.TRACE;

    public static LogTracker create() {
        return new LogTracker();
    }

    public LogTracker recordForLevel(LogLevel level) {
        this.level = level;
        this.resetLoggingFramework();
        this.prepareLoggingFramework();
        return this;
    }

    public LogTracker recordForObject(Object sut) {
        Class<?> type = sut.getClass();
        this.recordForType(type);
        return this;
    }

    public LogTracker recordForType(Class<?> type) {
        this.loggingSources.add(type);
        this.addAppenderToType(type);
        return this;
    }

    public boolean contains(String loggingStatement) {
        List list = this.listAppender.list;
        for (ILoggingEvent event : list) {
            if (!event.getFormattedMessage().contains(loggingStatement)) continue;
            return true;
        }
        return false;
    }

    public int size() {
        return this.listAppender.list.size();
    }

    public void resetLoggingFramework() {
        this.listAppender.stop();
        this.resetLoggingContext();
    }

    public void prepareLoggingFramework() {
        this.resetLoggingContext();
        this.addAppenderToLoggingSources();
        this.listAppender.start();
    }

    private void addAppenderToLoggingSources() {
        for (Class<?> logSource : this.loggingSources) {
            this.addAppenderToType(logSource);
        }
    }

    private void addAppenderToType(Class<?> type) {
        Logger logger = (Logger)LoggerFactory.getLogger(type);
        logger.addAppender(this.listAppender);
        logger.setLevel(this.level.internalLevel);
    }

    private void resetLoggingContext() {
        this.loggerContext.reset();
    }

    public static enum LogLevel {
        TRACE(Level.TRACE),
        DEBUG(Level.DEBUG),
        INFO(Level.INFO),
        WARN(Level.WARN),
        ERROR(Level.ERROR);

        Level internalLevel;

        private LogLevel(Level level) {
            this.internalLevel = level;
        }
    }
}

