/*
 * Decompiled with CFR 0.152.
 */
package com.canoo.dp.impl.platform.client;

import com.canoo.dp.impl.platform.core.Assert;
import com.canoo.platform.client.ClientConfiguration;
import com.canoo.platform.client.spi.ServiceProvider;
import java.util.concurrent.locks.Lock;
import java.util.concurrent.locks.ReentrantLock;
import org.apiguardian.api.API;

@API(since="0.x", status=API.Status.INTERNAL)
public abstract class AbstractServiceProvider<S>
implements ServiceProvider<S> {
    private final Lock creationLock = new ReentrantLock();
    private S service;
    private final Class<S> serviceClass;

    public AbstractServiceProvider(Class<S> serviceClass) {
        this.serviceClass = (Class)Assert.requireNonNull(serviceClass, (String)"serviceClass");
    }

    protected abstract S createService(ClientConfiguration var1);

    @Override
    public boolean isActive(ClientConfiguration configuration) {
        return true;
    }

    @Override
    public final S getService(ClientConfiguration configuration) {
        Assert.requireNonNull((Object)configuration, (String)"configuration");
        this.creationLock.lock();
        try {
            this.service = this.createService(configuration);
        }
        finally {
            this.creationLock.unlock();
        }
        return this.service;
    }

    @Override
    public final Class<S> getServiceType() {
        return this.serviceClass;
    }
}

