/*
 * Decompiled with CFR 0.152.
 */
package com.canoo.dp.impl.platform.client;

import com.canoo.dp.impl.platform.core.Assert;
import com.canoo.dp.impl.platform.core.SimpleDolphinPlatformThreadFactory;
import com.canoo.dp.impl.platform.core.SimpleUncaughtExceptionHandler;
import com.canoo.dp.impl.platform.core.http.DefaultHttpURLConnectionFactory;
import com.canoo.platform.client.ClientConfiguration;
import com.canoo.platform.core.http.HttpURLConnectionFactory;
import java.net.CookieManager;
import java.net.CookieStore;
import java.util.List;
import java.util.Map;
import java.util.Properties;
import java.util.Set;
import java.util.concurrent.Executor;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.ThreadFactory;
import org.apiguardian.api.API;

@API(since="0.20", status=API.Status.INTERNAL)
public class DefaultClientConfiguration
implements ClientConfiguration {
    private final Properties internalProperties = new Properties();

    public DefaultClientConfiguration() {
        this.setUncaughtExceptionHandler((Thread.UncaughtExceptionHandler)new SimpleUncaughtExceptionHandler());
        this.setUiUncaughtExceptionHandler((Thread.UncaughtExceptionHandler)new SimpleUncaughtExceptionHandler());
        this.setBackgroundExecutor(Executors.newCachedThreadPool((ThreadFactory)new SimpleDolphinPlatformThreadFactory()));
        this.setCookieStore(new CookieManager().getCookieStore());
        this.setHttpURLConnectionFactory((HttpURLConnectionFactory)new DefaultHttpURLConnectionFactory());
    }

    public DefaultClientConfiguration(Properties prop) {
        this();
        Assert.requireNonNull((Object)prop, (String)"prop");
        this.internalProperties.putAll((Map<?, ?>)prop);
    }

    @Override
    public <T> T getObjectProperty(String key) {
        return (T)this.internalProperties.get(key);
    }

    @Override
    public <T> T getObjectProperty(String key, T defaultValue) {
        if (this.containsProperty(key)) {
            return this.getObjectProperty(key);
        }
        return defaultValue;
    }

    @Override
    public <T> void setObjectProperty(String key, T value) {
        this.internalProperties.put(key, value);
    }

    public boolean containsProperty(String key) {
        return this.internalProperties.containsKey(key);
    }

    public Set<String> getPropertyKeys() {
        return this.internalProperties.stringPropertyNames();
    }

    @Override
    public Executor getUiExecutor() {
        return (Executor)this.getObjectProperty("platform.ui.executor");
    }

    @Override
    public ExecutorService getBackgroundExecutor() {
        return (ExecutorService)this.getObjectProperty("platform.background.executor");
    }

    @Override
    public Thread.UncaughtExceptionHandler getUncaughtExceptionHandler() {
        return (Thread.UncaughtExceptionHandler)this.getObjectProperty("platform.background.uncaughtExceptionHandler");
    }

    @Override
    public Thread.UncaughtExceptionHandler getUiUncaughtExceptionHandler() {
        return (Thread.UncaughtExceptionHandler)this.getObjectProperty("platform.ui.uncaughtExceptionHandler");
    }

    @Override
    public CookieStore getCookieStore() {
        return (CookieStore)this.getObjectProperty("platform.http.cookieStore");
    }

    @Override
    public HttpURLConnectionFactory getHttpURLConnectionFactory() {
        return (HttpURLConnectionFactory)this.getObjectProperty("platform.http.connectionFactory");
    }

    @Override
    public void setUiExecutor(Executor executor) {
        this.internalProperties.put("platform.ui.executor", executor);
    }

    @Override
    public void setBackgroundExecutor(ExecutorService service) {
        this.internalProperties.put("platform.background.executor", service);
    }

    @Override
    public void setUncaughtExceptionHandler(Thread.UncaughtExceptionHandler uncaughtExceptionHandler) {
        this.setObjectProperty("platform.background.uncaughtExceptionHandler", uncaughtExceptionHandler);
    }

    @Override
    public void setUiUncaughtExceptionHandler(Thread.UncaughtExceptionHandler uncaughtExceptionHandler) {
        this.setObjectProperty("platform.ui.uncaughtExceptionHandler", uncaughtExceptionHandler);
    }

    @Override
    public void setHttpURLConnectionFactory(HttpURLConnectionFactory httpURLConnectionFactory) {
        this.setObjectProperty("platform.http.connectionFactory", httpURLConnectionFactory);
    }

    @Override
    public void setCookieStore(CookieStore cookieStore) {
        this.internalProperties.put("platform.http.cookieStore", cookieStore);
    }

    @Override
    public void setStringProperty(String key, String value) {
        this.setObjectProperty(key, value);
    }

    @Override
    public void setBooleanProperty(String key, boolean value) {
        this.setObjectProperty(key, value);
    }

    @Override
    public void setIntProperty(String key, int value) {
        this.setObjectProperty(key, value);
    }

    @Override
    public void setLongProperty(String key, long value) {
        this.setObjectProperty(key, value);
    }

    @Override
    public void setListProperty(String key, List<String> value) {
        this.setObjectProperty(key, value);
    }

    public String getProperty(String key, String defaultValue) {
        return this.getObjectProperty(key, defaultValue);
    }

    public String getProperty(String key) {
        return (String)this.getObjectProperty(key);
    }

    public boolean getBooleanProperty(String key, boolean defaultValue) {
        return this.getObjectProperty(key, defaultValue);
    }

    public int getIntProperty(String key, int defaultValue) {
        return this.getObjectProperty(key, defaultValue);
    }

    public long getLongProperty(String key, long defaultValue) {
        return this.getObjectProperty(key, defaultValue);
    }

    public List<String> getListProperty(String key, List<String> defaultValues) {
        return this.getObjectProperty(key, defaultValues);
    }
}

