/*
 * Decompiled with CFR 0.152.
 */
package com.canoo.dp.impl.platform.client.config;

import com.canoo.dp.impl.platform.client.DefaultClientConfiguration;
import com.canoo.dp.impl.platform.core.Assert;
import java.io.IOException;
import java.io.InputStream;
import java.util.Properties;
import org.apiguardian.api.API;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@API(since="0.x", status=API.Status.INTERNAL)
public class ConfigurationFileLoader {
    private static final Logger LOG = LoggerFactory.getLogger(ConfigurationFileLoader.class);
    private static final String PLATFORM_LOCATION = "platform.properties";
    private static final String DEFAULT_LOCATION = "dolphin.properties";
    private static final String JAR_LOCATION = "META-INF/dolphin.properties";

    private ConfigurationFileLoader() {
    }

    public static DefaultClientConfiguration loadConfiguration(String ... additionalLocations) {
        DefaultClientConfiguration configuration = ConfigurationFileLoader.createConfiguration(additionalLocations);
        Assert.requireNonNull((Object)configuration, (String)"configuration");
        LOG.debug("Configuration created with {} properties", (Object)configuration.getPropertyKeys().size());
        if (LOG.isTraceEnabled()) {
            for (String key : configuration.getPropertyKeys()) {
                LOG.debug("Dolphin Platform configured with '{}'='{}'", (Object)key, (Object)configuration.getProperty(key, null));
            }
        }
        return configuration;
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private static DefaultClientConfiguration createConfiguration(String ... additionalLocations) {
        try {
            InputStream inputStream;
            ClassLoader classLoader = Thread.currentThread().getContextClassLoader();
            if (additionalLocations != null) {
                for (String location : additionalLocations) {
                    LOG.trace("Trying to load configuration at '" + location + "'");
                    try (InputStream inputStream2 = classLoader.getResourceAsStream(location);){
                        if (inputStream2 != null) {
                            DefaultClientConfiguration defaultClientConfiguration = ConfigurationFileLoader.readConfig(inputStream2);
                            return defaultClientConfiguration;
                        }
                    }
                    catch (Exception e) {
                        LOG.trace("No config found at '" + location + "'");
                    }
                }
            }
            try {
                inputStream = classLoader.getResourceAsStream(PLATFORM_LOCATION);
                Throwable throwable = null;
                try {
                    LOG.trace("Trying to load configuration at 'platform.properties'");
                    if (inputStream != null) {
                        DefaultClientConfiguration defaultClientConfiguration = ConfigurationFileLoader.readConfig(inputStream);
                        return defaultClientConfiguration;
                    }
                }
                catch (Throwable throwable2) {
                    throwable = throwable2;
                    throw throwable2;
                }
                finally {
                    if (inputStream != null) {
                        if (throwable != null) {
                            try {
                                inputStream.close();
                            }
                            catch (Throwable throwable3) {
                                throwable.addSuppressed(throwable3);
                            }
                        } else {
                            inputStream.close();
                        }
                    }
                }
            }
            catch (Exception e) {
                LOG.trace("No config found at 'platform.properties'");
            }
            try {
                inputStream = classLoader.getResourceAsStream(DEFAULT_LOCATION);
                Throwable throwable = null;
                try {
                    LOG.trace("Trying to load configuration at 'dolphin.properties'");
                    if (inputStream != null) {
                        DefaultClientConfiguration defaultClientConfiguration = ConfigurationFileLoader.readConfig(inputStream);
                        return defaultClientConfiguration;
                    }
                }
                catch (Throwable throwable4) {
                    throwable = throwable4;
                    throw throwable4;
                }
                finally {
                    if (inputStream != null) {
                        if (throwable != null) {
                            try {
                                inputStream.close();
                            }
                            catch (Throwable throwable5) {
                                throwable.addSuppressed(throwable5);
                            }
                        } else {
                            inputStream.close();
                        }
                    }
                }
            }
            catch (Exception e) {
                LOG.trace("No config found at 'dolphin.properties'");
            }
            try {
                inputStream = classLoader.getResourceAsStream(JAR_LOCATION);
                Throwable throwable = null;
                try {
                    LOG.trace("Trying to load configuration at 'META-INF/dolphin.properties'");
                    if (inputStream == null) return new DefaultClientConfiguration();
                    DefaultClientConfiguration defaultClientConfiguration = ConfigurationFileLoader.readConfig(inputStream);
                    return defaultClientConfiguration;
                }
                catch (Throwable throwable6) {
                    throwable = throwable6;
                    throw throwable6;
                }
                finally {
                    if (inputStream != null) {
                        if (throwable != null) {
                            try {
                                inputStream.close();
                            }
                            catch (Throwable throwable7) {
                                throwable.addSuppressed(throwable7);
                            }
                        } else {
                            inputStream.close();
                        }
                    }
                }
            }
            catch (Exception e) {
                LOG.trace("No config found at 'META-INF/dolphin.properties'");
            }
            return new DefaultClientConfiguration();
        }
        catch (Exception e) {
            throw new RuntimeException("Can not create configuration!", e);
        }
    }

    private static DefaultClientConfiguration readConfig(InputStream input) throws IOException {
        Assert.requireNonNull((Object)input, (String)"input");
        Properties prop = new Properties();
        prop.load(input);
        return new DefaultClientConfiguration(prop);
    }
}

