/*
 * Decompiled with CFR 0.152.
 */
package com.canoo.dp.impl.platform.client.http;

import com.canoo.dp.impl.platform.client.http.HttpProvider;
import com.canoo.dp.impl.platform.core.Assert;
import com.canoo.platform.client.ClientConfiguration;
import com.canoo.platform.core.functional.Promise;
import com.canoo.platform.core.http.BadResponseException;
import com.canoo.platform.core.http.HttpException;
import com.canoo.platform.core.http.HttpResponse;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.Executor;
import java.util.concurrent.ExecutorService;
import java.util.function.Consumer;
import org.apiguardian.api.API;

@API(since="0.x", status=API.Status.INTERNAL)
public class HttpCallExecutorImpl<R>
implements Promise<HttpResponse<R>, HttpException> {
    private final ExecutorService executor;
    private final HttpProvider<R> provider;
    private final Executor uiExecutor;
    private Consumer<HttpResponse<R>> onDone;
    private Consumer<HttpException> errorHandler;

    public HttpCallExecutorImpl(ClientConfiguration configuration, HttpProvider<R> provider) {
        Assert.requireNonNull((Object)configuration, (String)"configuration");
        this.executor = configuration.getBackgroundExecutor();
        this.uiExecutor = configuration.getUiExecutor();
        this.provider = (HttpProvider)Assert.requireNonNull(provider, (String)"provider");
    }

    public HttpCallExecutorImpl<R> onDone(Consumer<HttpResponse<R>> onDone) {
        this.onDone = onDone;
        return this;
    }

    public HttpCallExecutorImpl<R> onError(Consumer<HttpException> errorHandler) {
        this.errorHandler = errorHandler;
        return this;
    }

    public CompletableFuture<HttpResponse<R>> execute() {
        CompletableFuture<HttpResponse<R>> completableFuture = new CompletableFuture<HttpResponse<R>>();
        this.executor.submit(() -> {
            try {
                HttpResponse<R> result = this.provider.get();
                int statusCode = result.getStatusCode();
                if (statusCode >= 300) {
                    BadResponseException e = new BadResponseException(result, "Bad Response: " + statusCode);
                    if (this.errorHandler != null) {
                        this.uiExecutor.execute(() -> this.lambda$null$0((HttpException)e));
                    }
                    completableFuture.completeExceptionally((Throwable)e);
                } else {
                    if (this.onDone != null) {
                        this.uiExecutor.execute(() -> this.onDone.accept(result));
                    }
                    completableFuture.complete(result);
                }
            }
            catch (HttpException e) {
                if (this.errorHandler != null) {
                    this.uiExecutor.execute(() -> this.errorHandler.accept(e));
                }
                completableFuture.completeExceptionally(e);
            }
        });
        return completableFuture;
    }

    private /* synthetic */ void lambda$null$0(HttpException e) {
        this.errorHandler.accept(e);
    }
}

