/*
 * Decompiled with CFR 0.152.
 */
package com.canoo.dp.impl.platform.client.http;

import com.canoo.dp.impl.platform.client.http.HttpCallResponseBuilderImpl;
import com.canoo.dp.impl.platform.core.Assert;
import com.canoo.dp.impl.platform.core.http.HttpClientConnection;
import com.canoo.dp.impl.platform.core.http.HttpHeaderImpl;
import com.canoo.platform.client.ClientConfiguration;
import com.canoo.platform.core.DolphinRuntimeException;
import com.canoo.platform.core.http.ByteArrayProvider;
import com.canoo.platform.core.http.HttpCallRequestBuilder;
import com.canoo.platform.core.http.HttpCallResponseBuilder;
import com.canoo.platform.core.http.HttpHeader;
import com.canoo.platform.core.http.HttpURLConnectionHandler;
import com.google.gson.Gson;
import java.util.Collections;
import java.util.List;
import java.util.concurrent.atomic.AtomicBoolean;
import org.apiguardian.api.API;

@API(since="0.x", status=API.Status.INTERNAL)
public class HttpCallRequestBuilderImpl
implements HttpCallRequestBuilder {
    private final HttpClientConnection connection;
    private final Gson gson;
    private final List<HttpURLConnectionHandler> requestHandlers;
    private final List<HttpURLConnectionHandler> responseHandlers;
    private final ClientConfiguration configuration;
    private final AtomicBoolean done = new AtomicBoolean(false);

    public HttpCallRequestBuilderImpl(HttpClientConnection connection, Gson gson, List<HttpURLConnectionHandler> requestHandlers, List<HttpURLConnectionHandler> responseHandlers, ClientConfiguration configuration) {
        this.connection = (HttpClientConnection)Assert.requireNonNull((Object)connection, (String)"connection");
        this.gson = (Gson)Assert.requireNonNull((Object)gson, (String)"gson");
        this.configuration = configuration;
        Assert.requireNonNull(requestHandlers, (String)"requestHandlers");
        this.requestHandlers = Collections.unmodifiableList(requestHandlers);
        Assert.requireNonNull(responseHandlers, (String)"responseHandlers");
        this.responseHandlers = Collections.unmodifiableList(responseHandlers);
    }

    public HttpCallRequestBuilder withHeader(String name, String content) {
        this.connection.addRequestHeader((HttpHeader)new HttpHeaderImpl(name, content));
        return this;
    }

    public HttpCallResponseBuilder withContent(byte[] content, String contentType) {
        this.withHeader("Content-Type", contentType);
        this.connection.setDoOutput(true);
        return this.continueWithResponseBuilder(() -> content);
    }

    public <I> HttpCallResponseBuilder withContent(I content) {
        return this.withContent(this.gson.toJson(content), "application/json;charset=utf-8");
    }

    public HttpCallResponseBuilder withoutContent() {
        return this.continueWithResponseBuilder(() -> new byte[0]);
    }

    private HttpCallResponseBuilder continueWithResponseBuilder(ByteArrayProvider dataProvider) {
        Assert.requireNonNull((Object)dataProvider, (String)"dataProvider");
        if (this.done.get()) {
            throw new DolphinRuntimeException("Request already defined!");
        }
        this.done.set(true);
        return new HttpCallResponseBuilderImpl(this.connection, dataProvider, this.gson, this.requestHandlers, this.responseHandlers, this.configuration);
    }
}

