/*
 * Decompiled with CFR 0.152.
 */
package com.canoo.dp.impl.platform.client.http;

import com.canoo.dp.impl.platform.client.http.HttpCallExecutorImpl;
import com.canoo.dp.impl.platform.client.http.HttpResponseImpl;
import com.canoo.dp.impl.platform.client.http.ResponseContentConverter;
import com.canoo.dp.impl.platform.client.http.SimpleByteArrayProvider;
import com.canoo.dp.impl.platform.core.Assert;
import com.canoo.dp.impl.platform.core.http.HttpClientConnection;
import com.canoo.dp.impl.platform.core.http.HttpHeaderImpl;
import com.canoo.platform.client.ClientConfiguration;
import com.canoo.platform.core.DolphinRuntimeException;
import com.canoo.platform.core.functional.Promise;
import com.canoo.platform.core.http.ByteArrayProvider;
import com.canoo.platform.core.http.ConnectionException;
import com.canoo.platform.core.http.HttpCallResponseBuilder;
import com.canoo.platform.core.http.HttpException;
import com.canoo.platform.core.http.HttpHeader;
import com.canoo.platform.core.http.HttpResponse;
import com.canoo.platform.core.http.HttpURLConnectionHandler;
import com.google.gson.Gson;
import java.io.IOException;
import java.util.Collections;
import java.util.List;
import java.util.concurrent.atomic.AtomicBoolean;
import org.apiguardian.api.API;

@API(since="0.x", status=API.Status.INTERNAL)
public class HttpCallResponseBuilderImpl
implements HttpCallResponseBuilder {
    private final HttpClientConnection connection;
    private final Gson gson;
    private final AtomicBoolean handled = new AtomicBoolean(false);
    private final List<HttpURLConnectionHandler> requestHandlers;
    private final List<HttpURLConnectionHandler> responseHandlers;
    private final ByteArrayProvider dataProvider;
    private final ClientConfiguration configuration;

    public HttpCallResponseBuilderImpl(HttpClientConnection connection, ByteArrayProvider dataProvider, Gson gson, List<HttpURLConnectionHandler> requestHandlers, List<HttpURLConnectionHandler> responseHandlers, ClientConfiguration configuration) {
        this.connection = (HttpClientConnection)Assert.requireNonNull((Object)connection, (String)"connection");
        this.dataProvider = (ByteArrayProvider)Assert.requireNonNull((Object)dataProvider, (String)"dataProvider");
        this.gson = (Gson)Assert.requireNonNull((Object)gson, (String)"gson");
        this.configuration = (ClientConfiguration)Assert.requireNonNull((Object)configuration, (String)"configuration");
        Assert.requireNonNull(requestHandlers, (String)"requestHandlers");
        this.requestHandlers = Collections.unmodifiableList(requestHandlers);
        Assert.requireNonNull(responseHandlers, (String)"responseHandlers");
        this.responseHandlers = Collections.unmodifiableList(responseHandlers);
    }

    public Promise<HttpResponse<ByteArrayProvider>, HttpException> readBytes() {
        ResponseContentConverter<ByteArrayProvider> converter = b -> new SimpleByteArrayProvider(b);
        return this.createExecutor(converter);
    }

    public Promise<HttpResponse<String>, HttpException> readString() {
        this.connection.addRequestHeader((HttpHeader)new HttpHeaderImpl("Accept-Charset", "UTF-8"));
        ResponseContentConverter<String> converter = b -> new String(b, "UTF-8");
        return this.createExecutor(converter);
    }

    public <R> Promise<HttpResponse<R>, HttpException> readObject(Class<R> responseType) {
        Assert.requireNonNull(responseType, (String)"responseType");
        this.connection.addRequestHeader((HttpHeader)new HttpHeaderImpl("Accept-Charset", "UTF-8"));
        this.connection.addRequestHeader((HttpHeader)new HttpHeaderImpl("Accept", "application/json;charset=utf-8"));
        ResponseContentConverter<Object> converter = b -> this.gson.fromJson(new String(b, "UTF-8"), responseType);
        return this.createExecutor(converter);
    }

    public Promise<HttpResponse<Void>, HttpException> withoutResult() {
        ResponseContentConverter<Void> converter = b -> null;
        return this.createExecutor(converter);
    }

    public Promise<HttpResponse<ByteArrayProvider>, HttpException> readBytes(String contentType) {
        Assert.requireNonNull((Object)contentType, (String)"contentType");
        this.connection.addRequestHeader((HttpHeader)new HttpHeaderImpl("Accept", contentType));
        return this.readBytes();
    }

    public Promise<HttpResponse<String>, HttpException> readString(String contentType) {
        Assert.requireNonNull((Object)contentType, (String)"contentType");
        this.connection.addRequestHeader((HttpHeader)new HttpHeaderImpl("Accept", contentType));
        return this.readString();
    }

    private <R> Promise<HttpResponse<R>, HttpException> createExecutor(ResponseContentConverter<R> converter) {
        return new HttpCallExecutorImpl(this.configuration, () -> this.handleRequest(converter));
    }

    private <R> HttpResponse<R> handleRequest(ResponseContentConverter<R> converter) throws HttpException {
        Assert.requireNonNull(converter, (String)"converter");
        if (this.handled.get()) {
            throw new DolphinRuntimeException("Http call already handled");
        }
        this.handled.set(true);
        this.requestHandlers.forEach(h -> h.handle(this.connection.getConnection()));
        byte[] rawBytes = this.dataProvider.get();
        try {
            this.connection.writeRequestContent(rawBytes);
        }
        catch (IOException e) {
            throw new ConnectionException("Can not connect to server", (Throwable)e);
        }
        try {
            int responseCode = this.connection.readResponseCode();
            byte[] rawContent = this.connection.readResponseContent();
            this.responseHandlers.forEach(h -> h.handle(this.connection.getConnection()));
            R content = converter.convert(rawContent);
            List headers = this.connection.getResponseHeaders();
            return new HttpResponseImpl<R>(headers, responseCode, rawContent, content);
        }
        catch (IOException e) {
            throw new ConnectionException("No response from server", (Throwable)e);
        }
        catch (Exception e) {
            throw new HttpException("Can not handle response", (Throwable)e);
        }
    }
}

