/*
 * Decompiled with CFR 0.152.
 */
package com.canoo.dp.impl.platform.client.http;

import com.canoo.dp.impl.platform.client.http.HttpCallRequestBuilderImpl;
import com.canoo.dp.impl.platform.core.Assert;
import com.canoo.dp.impl.platform.core.http.DefaultHttpURLConnectionFactory;
import com.canoo.dp.impl.platform.core.http.HttpClientConnection;
import com.canoo.platform.client.ClientConfiguration;
import com.canoo.platform.core.DolphinRuntimeException;
import com.canoo.platform.core.http.HttpCallRequestBuilder;
import com.canoo.platform.core.http.HttpClient;
import com.canoo.platform.core.http.HttpURLConnectionFactory;
import com.canoo.platform.core.http.HttpURLConnectionHandler;
import com.canoo.platform.core.http.RequestMethod;
import com.google.gson.Gson;
import java.io.IOException;
import java.net.URI;
import java.net.URISyntaxException;
import java.util.List;
import java.util.concurrent.CopyOnWriteArrayList;
import org.apiguardian.api.API;

@API(since="0.x", status=API.Status.INTERNAL)
public class HttpClientImpl
implements HttpClient {
    private final Gson gson;
    private final HttpURLConnectionFactory httpURLConnectionFactory;
    private final List<HttpURLConnectionHandler> requestHandlers = new CopyOnWriteArrayList<HttpURLConnectionHandler>();
    private final List<HttpURLConnectionHandler> responseHandlers = new CopyOnWriteArrayList<HttpURLConnectionHandler>();
    private final ClientConfiguration configuration;

    public HttpClientImpl(Gson gson, ClientConfiguration configuration) {
        this(gson, (HttpURLConnectionFactory)new DefaultHttpURLConnectionFactory(), configuration);
    }

    public HttpClientImpl(Gson gson, HttpURLConnectionFactory httpURLConnectionFactory, ClientConfiguration configuration) {
        this.gson = (Gson)Assert.requireNonNull((Object)gson, (String)"gson");
        this.httpURLConnectionFactory = (HttpURLConnectionFactory)Assert.requireNonNull((Object)httpURLConnectionFactory, (String)"httpURLConnectionFactory");
        this.configuration = configuration;
    }

    public void addRequestHandler(HttpURLConnectionHandler handler) {
        Assert.requireNonNull((Object)handler, (String)"handler");
        this.requestHandlers.add(handler);
    }

    public void addResponseHandler(HttpURLConnectionHandler handler) {
        Assert.requireNonNull((Object)handler, (String)"handler");
        this.responseHandlers.add(handler);
    }

    public HttpCallRequestBuilder request(String url, RequestMethod method) {
        try {
            return this.request(new URI(url), method);
        }
        catch (URISyntaxException e) {
            throw new DolphinRuntimeException("HTTP error", (Throwable)e);
        }
    }

    public HttpCallRequestBuilder request(URI url, RequestMethod method) {
        try {
            Assert.requireNonNull((Object)url, (String)"url");
            Assert.requireNonNull((Object)method, (String)"method");
            HttpClientConnection clientConnection = new HttpClientConnection(this.httpURLConnectionFactory, url, method);
            return new HttpCallRequestBuilderImpl(clientConnection, this.gson, this.requestHandlers, this.responseHandlers, this.configuration);
        }
        catch (IOException e) {
            throw new DolphinRuntimeException("HTTP error", (Throwable)e);
        }
    }
}

