/*
 * Decompiled with CFR 0.152.
 */
package com.canoo.dp.impl.platform.client.http;

import com.canoo.dp.impl.platform.client.AbstractServiceProvider;
import com.canoo.dp.impl.platform.client.http.HttpClientImpl;
import com.canoo.platform.client.ClientConfiguration;
import com.canoo.platform.client.PlatformClient;
import com.canoo.platform.core.PlatformConfiguration;
import com.canoo.platform.core.http.HttpClient;
import com.canoo.platform.core.http.HttpURLConnectionFactory;
import com.canoo.platform.core.http.spi.RequestHandlerProvider;
import com.canoo.platform.core.http.spi.ResponseHandlerProvider;
import com.google.gson.Gson;
import java.util.Iterator;
import java.util.ServiceLoader;
import org.apiguardian.api.API;

@API(since="0.x", status=API.Status.INTERNAL)
public class HttpClientProvider
extends AbstractServiceProvider<HttpClient> {
    public HttpClientProvider() {
        super(HttpClient.class);
    }

    @Override
    protected HttpClient createService(ClientConfiguration configuration) {
        HttpURLConnectionFactory connectionFactory = configuration.getHttpURLConnectionFactory();
        HttpClientImpl client = new HttpClientImpl(PlatformClient.getService(Gson.class), connectionFactory, configuration);
        ServiceLoader<RequestHandlerProvider> requestLoader = ServiceLoader.load(RequestHandlerProvider.class);
        Iterator<RequestHandlerProvider> requestIterator = requestLoader.iterator();
        while (requestIterator.hasNext()) {
            client.addRequestHandler(requestIterator.next().getHandler((PlatformConfiguration)configuration));
        }
        ServiceLoader<ResponseHandlerProvider> responseLoader = ServiceLoader.load(ResponseHandlerProvider.class);
        Iterator<ResponseHandlerProvider> responseIterator = responseLoader.iterator();
        while (responseIterator.hasNext()) {
            client.addResponseHandler(responseIterator.next().getHandler((PlatformConfiguration)configuration));
        }
        return client;
    }
}

