/*
 * Decompiled with CFR 0.152.
 */
package com.canoo.dp.impl.platform.client.http.cookie;

import com.canoo.dp.impl.platform.client.http.cookie.HttpClientCookieHandler;
import com.canoo.dp.impl.platform.core.Assert;
import com.canoo.platform.core.DolphinRuntimeException;
import com.canoo.platform.core.http.HttpURLConnectionHandler;
import java.net.HttpURLConnection;
import java.net.URISyntaxException;
import org.apiguardian.api.API;

@API(since="0.x", status=API.Status.INTERNAL)
public class CookieResponseHandler
implements HttpURLConnectionHandler {
    private final HttpClientCookieHandler clientCookieHandler;

    public CookieResponseHandler(HttpClientCookieHandler clientCookieHandler) {
        this.clientCookieHandler = (HttpClientCookieHandler)Assert.requireNonNull((Object)clientCookieHandler, (String)"clientCookieHandler");
    }

    public void handle(HttpURLConnection connection) {
        Assert.requireNonNull((Object)connection, (String)"connection");
        try {
            this.clientCookieHandler.updateCookiesFromResponse(connection);
        }
        catch (URISyntaxException e) {
            throw new DolphinRuntimeException("Can not read cookies from response", (Throwable)e);
        }
    }
}

