/*
 * Decompiled with CFR 0.152.
 */
package com.canoo.dp.impl.platform.client.http.cookie;

import com.canoo.dp.impl.platform.core.Assert;
import com.canoo.platform.core.DolphinRuntimeException;
import java.net.CookieStore;
import java.net.HttpCookie;
import java.net.HttpURLConnection;
import java.net.URISyntaxException;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import org.apiguardian.api.API;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@API(since="0.x", status=API.Status.INTERNAL)
public class HttpClientCookieHandler {
    private static final Logger LOG = LoggerFactory.getLogger(HttpClientCookieHandler.class);
    private final CookieStore cookieStore;

    public HttpClientCookieHandler(CookieStore cookieStore) {
        this.cookieStore = (CookieStore)Assert.requireNonNull((Object)cookieStore, (String)"cookieStore");
    }

    public void updateCookiesFromResponse(HttpURLConnection connection) throws URISyntaxException {
        Assert.requireNonNull((Object)connection, (String)"connection");
        LOG.debug("adding cookies from response to cookie store");
        Map<String, List<String>> headerFields = connection.getHeaderFields();
        List<String> cookiesHeader = headerFields.get("Set-Cookie");
        if (cookiesHeader != null) {
            LOG.debug("found '{}' header field", (Object)"Set-Cookie");
            for (String cookie : cookiesHeader) {
                if (cookie == null || cookie.isEmpty()) continue;
                LOG.debug("will parse '{}' header content '{}'", (Object)cookie);
                ArrayList<HttpCookie> cookies = new ArrayList<HttpCookie>();
                try {
                    cookies.addAll(HttpCookie.parse(cookie));
                }
                catch (Exception e) {
                    throw new DolphinRuntimeException("Can not convert 'Set-Cookie' response header field to http cookies. Bad content: " + cookie, (Throwable)e);
                }
                LOG.debug("Found {} http cookies in header", (Object)cookies.size());
                for (HttpCookie httpCookie : cookies) {
                    LOG.trace("Found Cookie '{}' for Domain '{}' at Ports '{}' with Path '{}", new Object[]{httpCookie.getValue(), httpCookie.getDomain(), httpCookie.getPortlist(), httpCookie.getPath()});
                    this.cookieStore.add(connection.getURL().toURI(), httpCookie);
                }
            }
        }
    }

    public void setRequestCookies(HttpURLConnection connection) throws URISyntaxException {
        Assert.requireNonNull((Object)connection, (String)"connection");
        LOG.debug("adding cookies from cookie store to request");
        if (this.cookieStore.getCookies().size() > 0) {
            String cookieValue = "";
            for (HttpCookie cookie : this.cookieStore.get(connection.getURL().toURI())) {
                LOG.trace("Cookie '{}' is for Domain '{}' at Ports '{}' with Path '{}", new Object[]{cookie.getValue(), cookie.getDomain(), cookie.getPortlist(), cookie.getPath()});
                cookieValue = cookieValue + cookie + ";";
            }
            if (!cookieValue.isEmpty()) {
                cookieValue = cookieValue.substring(0, cookieValue.length());
                LOG.debug("Adding '{}' header to request. Content: {}", (Object)"Set-Cookie", (Object)cookieValue);
                connection.setRequestProperty("Cookie", cookieValue);
            }
        }
    }
}

