/*
 * Decompiled with CFR 0.152.
 */
package com.canoo.dp.impl.platform.client.session;

import com.canoo.dp.impl.platform.core.Assert;
import com.canoo.platform.client.session.ClientSessionStore;
import com.canoo.platform.core.DolphinRuntimeException;
import com.canoo.platform.core.http.HttpURLConnectionHandler;
import java.net.HttpURLConnection;
import java.net.URISyntaxException;
import org.apiguardian.api.API;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@API(since="0.x", status=API.Status.INTERNAL)
public class ClientSessionRequestHandler
implements HttpURLConnectionHandler {
    private static final Logger LOG = LoggerFactory.getLogger(ClientSessionRequestHandler.class);
    private final ClientSessionStore clientSessionStore;

    public ClientSessionRequestHandler(ClientSessionStore clientSessionStore) {
        this.clientSessionStore = (ClientSessionStore)Assert.requireNonNull((Object)clientSessionStore, (String)"clientSessionStore");
    }

    public void handle(HttpURLConnection request) {
        Assert.requireNonNull((Object)request, (String)"request");
        try {
            String clientId = this.clientSessionStore.getClientIdentifierForUrl(request.getURL().toURI());
            if (clientId != null) {
                LOG.debug("Adding client id {} to http request at {}", (Object)clientId, (Object)request.getURL());
                request.setRequestProperty("dolphin_platform_intern_dolphinClientId", clientId);
            } else {
                LOG.debug("Request to application at {} without client id. PlatformClient id not defined until now.", (Object)request.getURL());
            }
        }
        catch (URISyntaxException e) {
            LOG.error("Exception while converting to request URL {} to URI", (Object)request.getURL());
            throw new DolphinRuntimeException("Exception while converting URL " + request.getURL() + "to URI", (Throwable)e);
        }
    }
}

