/*
 * Decompiled with CFR 0.152.
 */
package com.canoo.dp.impl.platform.client.session;

import com.canoo.dp.impl.platform.core.Assert;
import com.canoo.platform.client.session.ClientSessionStore;
import com.canoo.platform.core.DolphinRuntimeException;
import com.canoo.platform.core.http.HttpURLConnectionHandler;
import java.net.HttpURLConnection;
import java.net.URISyntaxException;
import org.apiguardian.api.API;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@API(since="0.x", status=API.Status.INTERNAL)
public class ClientSessionResponseHandler
implements HttpURLConnectionHandler {
    private static final Logger LOG = LoggerFactory.getLogger(ClientSessionResponseHandler.class);
    private final ClientSessionStore clientSessionStore;

    public ClientSessionResponseHandler(ClientSessionStore clientSessionStore) {
        this.clientSessionStore = (ClientSessionStore)Assert.requireNonNull((Object)clientSessionStore, (String)"clientSessionStore");
    }

    public void handle(HttpURLConnection response) {
        Assert.requireNonNull((Object)response, (String)"response");
        String clientIdInHeader = response.getHeaderField("dolphin_platform_intern_dolphinClientId");
        try {
            this.clientSessionStore.setClientIdentifierForUrl(response.getURL().toURI(), clientIdInHeader);
        }
        catch (URISyntaxException e) {
            LOG.error("Exception while converting to response URL {} to URI", (Object)response.getURL());
            throw new DolphinRuntimeException("Exception while converting URL " + response.getURL() + "to URI", (Throwable)e);
        }
    }
}

