/*
 * Decompiled with CFR 0.152.
 */
package com.canoo.dp.impl.platform.client.session;

import com.canoo.dp.impl.platform.client.session.SimpleUrlToAppDomainConverter;
import com.canoo.dp.impl.platform.core.Assert;
import com.canoo.platform.client.session.ClientSessionStore;
import java.net.URI;
import java.util.HashMap;
import java.util.Map;
import java.util.concurrent.locks.Lock;
import java.util.concurrent.locks.ReentrantLock;
import java.util.function.Function;
import org.apiguardian.api.API;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@API(since="0.x", status=API.Status.INTERNAL)
public class ClientSessionStoreImpl
implements ClientSessionStore {
    private static final Logger LOG = LoggerFactory.getLogger(ClientSessionStoreImpl.class);
    private final Lock mapLock = new ReentrantLock();
    private final Map<String, String> domainToId = new HashMap<String, String>();
    private Function<URI, String> domainToAppConverter = new SimpleUrlToAppDomainConverter();

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public String getClientIdentifierForUrl(URI url) {
        Assert.requireNonNull((Object)url, (String)"url");
        String applicationDomain = this.domainToAppConverter.apply(url);
        if (applicationDomain == null) {
            throw new IllegalStateException("Can not define application domain for url " + url);
        }
        LOG.debug("searching for client id application domain: {}", (Object)applicationDomain);
        this.mapLock.lock();
        try {
            String clientId = this.domainToId.get(applicationDomain);
            LOG.debug("found client id '{}' for application domain {}", (Object)clientId, (Object)applicationDomain);
            String string = clientId;
            return string;
        }
        finally {
            this.mapLock.unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void setClientIdentifierForUrl(URI url, String clientId) {
        Assert.requireNonNull((Object)url, (String)"url");
        String applicationDomain = this.domainToAppConverter.apply(url);
        if (applicationDomain == null) {
            throw new IllegalStateException("Can not define application domain for url " + url);
        }
        LOG.debug("updating client id for application domain: {}", (Object)applicationDomain);
        this.mapLock.lock();
        try {
            if (this.domainToId.containsKey(applicationDomain)) {
                String storedId = this.domainToId.get(applicationDomain);
                if (clientId != null && !storedId.equals(clientId)) {
                    throw new IllegalStateException("PlatformClient Id for application domain " + applicationDomain + " already specified.");
                }
            } else {
                LOG.debug("Defining client id '{}' for application domain {}", (Object)clientId, (Object)applicationDomain);
                if (clientId == null) {
                    LOG.debug("Since client id for application domain {} is defined as 'null' it will be removed", (Object)applicationDomain);
                    this.domainToId.remove(applicationDomain);
                } else {
                    this.domainToId.put(applicationDomain, clientId);
                }
            }
        }
        finally {
            this.mapLock.unlock();
        }
    }

    @Override
    public void resetSession(URI url) {
        LOG.debug("Resetting client id for url {}", (Object)url);
        this.setClientIdentifierForUrl(url, null);
    }

    public Function<URI, String> getDomainToAppConverter() {
        return this.domainToAppConverter;
    }

    public void setDomainToAppConverter(Function<URI, String> domainToAppConverter) {
        this.domainToAppConverter = (Function)Assert.requireNonNull(domainToAppConverter, (String)"domainToAppConverter");
    }
}

