/*
 * Decompiled with CFR 0.152.
 */
package com.canoo.platform.client;

import com.canoo.dp.impl.platform.client.config.ConfigurationFileLoader;
import com.canoo.dp.impl.platform.core.Assert;
import com.canoo.dp.impl.platform.core.ansi.PlatformLogo;
import com.canoo.platform.client.ClientConfiguration;
import com.canoo.platform.client.HeadlessToolkit;
import com.canoo.platform.client.Toolkit;
import com.canoo.platform.client.spi.ServiceProvider;
import com.canoo.platform.core.DolphinRuntimeException;
import java.util.Collections;
import java.util.Map;
import java.util.ServiceLoader;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.atomic.AtomicBoolean;
import org.apiguardian.api.API;

@API(since="0.19.0", status=API.Status.EXPERIMENTAL)
public class PlatformClient {
    private static final String DEFAULT_LOCATION = "application.properties";
    private static PlatformClient INSTANCE;
    private final Map<Class<?>, ServiceProvider> providers = new ConcurrentHashMap();
    private final Map<Class<?>, Object> services = new ConcurrentHashMap();
    private final ClientConfiguration clientConfiguration;
    private AtomicBoolean isToolkitSet = new AtomicBoolean(false);

    private PlatformClient() {
        PlatformLogo.printLogo();
        this.clientConfiguration = ConfigurationFileLoader.loadConfiguration(DEFAULT_LOCATION);
        ServiceLoader<ServiceProvider> loader = ServiceLoader.load(ServiceProvider.class);
        for (ServiceProvider provider : loader) {
            if (!provider.isActive(this.clientConfiguration)) continue;
            Class serviceClass = provider.getServiceType();
            Assert.requireNonNull(serviceClass, (String)"serviceClass");
            if (this.providers.containsKey(serviceClass)) {
                throw new DolphinRuntimeException("Can not register more than 1 implementation for service type " + serviceClass);
            }
            this.providers.put(serviceClass, provider);
        }
        this.initImpl(new HeadlessToolkit());
    }

    private void initImpl(Toolkit toolkit) {
        this.services.clear();
        Assert.requireNonNull((Object)toolkit, (String)"toolkit");
        this.clientConfiguration.setUiExecutor(toolkit.getUiExecutor());
        this.isToolkitSet.set(true);
    }

    private Set<Class<?>> implGetAllServiceTypes() {
        return Collections.unmodifiableSet(this.providers.keySet());
    }

    private <S> boolean hasServiceImpl(Class<S> serviceClass) {
        Assert.requireNonNull(serviceClass, (String)"serviceClass");
        if (!this.isToolkitSet.get()) {
            throw new DolphinRuntimeException("Toolkit is not set!");
        }
        return this.providers.containsKey(serviceClass);
    }

    private synchronized <S> S getServiceImpl(Class<S> serviceClass) {
        Assert.requireNonNull(serviceClass, (String)"serviceClass");
        if (!this.isToolkitSet.get()) {
            throw new DolphinRuntimeException("Toolkit is not set!");
        }
        if (this.services.containsKey(serviceClass)) {
            Object service = this.services.get(serviceClass);
            return (S)service;
        }
        ServiceProvider serviceProvider = this.providers.get(serviceClass);
        Assert.requireNonNull((Object)serviceProvider, (String)"serviceProvider");
        Object service = serviceProvider.getService(this.clientConfiguration);
        Assert.requireNonNull(service, (String)"service");
        this.services.put(serviceClass, service);
        return service;
    }

    public static void init(Toolkit toolkit) {
        PlatformClient.getInstance().initImpl(toolkit);
    }

    public static ClientConfiguration getClientConfiguration() {
        return PlatformClient.getInstance().clientConfiguration;
    }

    public static <S> boolean hasService(Class<S> serviceClass) {
        return PlatformClient.getInstance().hasServiceImpl(serviceClass);
    }

    public static <S> S getService(Class<S> serviceClass) {
        return PlatformClient.getInstance().getServiceImpl(serviceClass);
    }

    public static Set<Class<?>> getAllServiceTypes() {
        return PlatformClient.getInstance().implGetAllServiceTypes();
    }

    private static synchronized PlatformClient getInstance() {
        if (INSTANCE == null) {
            INSTANCE = new PlatformClient();
        }
        return INSTANCE;
    }
}

