/*
 * Decompiled with CFR 0.152.
 */
package com.canoo.dp.impl.client.javafx;

import com.canoo.dp.impl.platform.core.Assert;
import com.canoo.platform.core.functional.Binding;
import com.canoo.platform.core.functional.Subscription;
import com.canoo.platform.remoting.client.javafx.BidirectionalConverter;
import com.canoo.platform.remoting.client.javafx.Converter;
import com.canoo.platform.remoting.client.javafx.binding.DolphinBinder;
import javafx.beans.property.Property;
import javafx.beans.value.ChangeListener;
import javafx.beans.value.ObservableValue;
import org.apiguardian.api.API;

@API(since="0.x", status=API.Status.INTERNAL)
public class DefaultDolphinBinder<S>
implements DolphinBinder<S> {
    private final com.canoo.platform.remoting.Property<S> property;

    public DefaultDolphinBinder(com.canoo.platform.remoting.Property<S> property) {
        this.property = (com.canoo.platform.remoting.Property)Assert.requireNonNull(property, (String)"property");
    }

    @Override
    public <T> Binding to(ObservableValue<T> observableValue, Converter<? super T, ? extends S> converter) {
        if (observableValue == null) {
            throw new IllegalArgumentException("observableValue must not be null");
        }
        if (converter == null) {
            throw new IllegalArgumentException("converter must not be null");
        }
        ChangeListener listener = (obs, oldVal, newVal) -> this.property.set(converter.convert(newVal));
        observableValue.addListener(listener);
        this.property.set(converter.convert(observableValue.getValue()));
        return () -> observableValue.removeListener(listener);
    }

    @Override
    public <T> Binding bidirectionalTo(Property<T> javaFxProperty, BidirectionalConverter<T, S> converter) {
        if (javaFxProperty == null) {
            throw new IllegalArgumentException("javaFxProperty must not be null");
        }
        if (converter == null) {
            throw new IllegalArgumentException("converter must not be null");
        }
        Binding unidirectionalBinding = this.to((ObservableValue<T>)javaFxProperty, (Converter<? super T, ? extends S>)converter);
        Subscription subscription = this.property.onChanged(e -> javaFxProperty.setValue(converter.convertBack(this.property.get())));
        return () -> {
            unidirectionalBinding.unbind();
            subscription.unsubscribe();
        };
    }
}

