/*
 * Decompiled with CFR 0.152.
 */
package com.canoo.dp.impl.client.javafx;

import com.canoo.dp.impl.platform.core.Assert;
import com.canoo.platform.core.functional.Binding;
import com.canoo.platform.core.functional.Subscription;
import com.canoo.platform.remoting.ListChangeEvent;
import com.canoo.platform.remoting.ListChangeListener;
import com.canoo.platform.remoting.ObservableList;
import com.canoo.platform.remoting.client.javafx.binding.JavaFXListBinder;
import java.util.Collection;
import java.util.IdentityHashMap;
import java.util.function.Function;
import java.util.stream.Collectors;
import javafx.collections.ListChangeListener;
import org.apiguardian.api.API;

@API(since="0.x", status=API.Status.INTERNAL)
public class DefaultJavaFXListBinder<S>
implements JavaFXListBinder<S> {
    private javafx.collections.ObservableList<S> list;
    private static IdentityHashMap<javafx.collections.ObservableList, javafx.collections.ObservableList> boundLists = new IdentityHashMap();

    public DefaultJavaFXListBinder(javafx.collections.ObservableList<S> list) {
        Assert.requireNonNull(list, (String)"list");
        this.list = list;
    }

    @Override
    public <T> Binding to(ObservableList<T> dolphinList, Function<? super T, ? extends S> converter) {
        Assert.requireNonNull(dolphinList, (String)"dolphinList");
        Assert.requireNonNull(converter, (String)"converter");
        if (boundLists.containsKey(this.list)) {
            throw new UnsupportedOperationException("A JavaFX list can only be bound to one Dolphin Platform list!");
        }
        boundLists.put(this.list, this.list);
        InternalListChangeListener listChangeListener = new InternalListChangeListener(converter);
        Subscription subscription = dolphinList.onChanged(listChangeListener);
        this.list.setAll((Collection)dolphinList.stream().map(converter).collect(Collectors.toList()));
        javafx.collections.ListChangeListener readOnlyListener = c -> {
            if (!listChangeListener.onChange) {
                throw new UnsupportedOperationException("A JavaFX list that is bound to a dolphin list can only be modified by the binding!");
            }
        };
        this.list.addListener(readOnlyListener);
        return () -> {
            subscription.unsubscribe();
            this.list.removeListener(readOnlyListener);
            boundLists.remove(this.list);
        };
    }

    @Override
    public <T> Binding bidirectionalTo(ObservableList<T> dolphinList, Function<? super T, ? extends S> converter, Function<? super S, ? extends T> backConverter) {
        Assert.requireNonNull(dolphinList, (String)"dolphinList");
        Assert.requireNonNull(converter, (String)"converter");
        Assert.requireNonNull(backConverter, (String)"backConverter");
        if (boundLists.containsKey(this.list)) {
            throw new IllegalStateException("A JavaFX list can only be bound to one Dolphin Platform list!");
        }
        InternalBidirectionalListChangeListener listChangeListener = new InternalBidirectionalListChangeListener(dolphinList, converter, backConverter);
        Subscription subscription = dolphinList.onChanged(listChangeListener);
        this.list.setAll((Collection)dolphinList.stream().map(converter).collect(Collectors.toList()));
        this.list.addListener(listChangeListener);
        return () -> {
            subscription.unsubscribe();
            this.list.removeListener((javafx.collections.ListChangeListener)listChangeListener);
        };
    }

    private class InternalBidirectionalListChangeListener<T>
    extends InternalListChangeListener<T>
    implements javafx.collections.ListChangeListener<S> {
        private final ObservableList<T> dolphinList;
        private final Function<? super S, ? extends T> backConverter;

        private InternalBidirectionalListChangeListener(ObservableList<T> dolphinList, Function<? super T, ? extends S> converter, Function<? super S, ? extends T> backConverter) {
            super(converter);
            this.dolphinList = dolphinList;
            this.backConverter = backConverter;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void onChanged(ListChangeListener.Change<? extends S> change) {
            if (this.onChange) {
                return;
            }
            this.onChange = true;
            try {
                while (change.next()) {
                    int index = change.getFrom();
                    if (change.wasRemoved() || change.wasReplaced()) {
                        for (int i = 0; i < change.getRemovedSize(); ++i) {
                            this.dolphinList.remove(index);
                        }
                    }
                    if (!change.wasAdded() && !change.wasReplaced()) continue;
                    this.dolphinList.addAll(index, (Collection)change.getAddedSubList().stream().map(this.backConverter).collect(Collectors.toList()));
                }
            }
            finally {
                this.onChange = false;
            }
        }
    }

    private class InternalListChangeListener<T>
    implements ListChangeListener<T> {
        private final Function<? super T, ? extends S> converter;
        protected boolean onChange;

        private InternalListChangeListener(Function<? super T, ? extends S> converter) {
            this.converter = converter;
            this.onChange = false;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void listChanged(ListChangeEvent<? extends T> e) {
            if (this.onChange) {
                return;
            }
            this.onChange = true;
            try {
                for (ListChangeEvent.Change c : e.getChanges()) {
                    int index = c.getFrom();
                    if (c.isRemoved() || c.isReplaced()) {
                        DefaultJavaFXListBinder.this.list.subList(index, index + c.getRemovedElements().size()).clear();
                    }
                    if (!c.isAdded() && !c.isReplaced()) continue;
                    DefaultJavaFXListBinder.this.list.addAll(index, (Collection)e.getSource().subList(index, c.getTo()).stream().map(this.converter).collect(Collectors.toList()));
                }
            }
            finally {
                this.onChange = false;
            }
        }
    }
}

