/*
 * Decompiled with CFR 0.152.
 */
package com.canoo.dp.impl.client.javafx;

import com.canoo.dp.impl.client.javafx.AbstractNumericDolphinBinder;
import com.canoo.platform.remoting.Property;
import com.canoo.platform.remoting.client.javafx.BidirectionalConverter;
import org.apiguardian.api.API;

@API(since="0.x", status=API.Status.INTERNAL)
public class DoubleDolphinBinder
extends AbstractNumericDolphinBinder<Double> {
    private static final double EPSILON = 1.0E-10;

    public DoubleDolphinBinder(Property<Double> property) {
        super(property);
    }

    @Override
    protected boolean equals(Number n, Double aDouble) {
        if (n == null && aDouble != null) {
            return false;
        }
        if (n != null && aDouble == null) {
            return false;
        }
        if (n == null && aDouble == null) {
            return true;
        }
        return Math.abs(n.doubleValue() - aDouble) < 1.0E-10;
    }

    @Override
    protected BidirectionalConverter<Number, Double> getConverter() {
        return new BidirectionalConverter<Number, Double>(){

            @Override
            public Number convertBack(Double value) {
                if (value == null) {
                    return 0.0;
                }
                return value;
            }

            @Override
            public Double convert(Number value) {
                if (value == null) {
                    return 0.0;
                }
                return value.doubleValue();
            }
        };
    }
}

