/*
 * Decompiled with CFR 0.152.
 */
package com.canoo.dp.impl.client.javafx;

import com.canoo.dp.impl.client.javafx.AbstractNumericDolphinBinder;
import com.canoo.platform.remoting.Property;
import com.canoo.platform.remoting.client.javafx.BidirectionalConverter;
import org.apiguardian.api.API;

@API(since="0.x", status=API.Status.INTERNAL)
public class FloatDolphinBinder
extends AbstractNumericDolphinBinder<Float> {
    private static final double EPSILON = (double)1.0E-10f;

    public FloatDolphinBinder(Property<Float> property) {
        super(property);
    }

    @Override
    protected boolean equals(Number n, Float aFloat) {
        if (n == null && aFloat != null) {
            return false;
        }
        if (n != null && aFloat == null) {
            return false;
        }
        if (n == null && aFloat == null) {
            return true;
        }
        return (double)Math.abs(n.floatValue() - aFloat.floatValue()) < (double)1.0E-10f;
    }

    @Override
    protected BidirectionalConverter<Number, Float> getConverter() {
        return new BidirectionalConverter<Number, Float>(){

            @Override
            public Number convertBack(Float value) {
                if (value == null) {
                    return Float.valueOf(0.0f);
                }
                return value;
            }

            @Override
            public Float convert(Number value) {
                if (value == null) {
                    return Float.valueOf(0.0f);
                }
                return Float.valueOf(value.floatValue());
            }
        };
    }
}

