/*
 * Decompiled with CFR 0.152.
 */
package com.canoo.platform.remoting.client.javafx;

import com.canoo.dp.impl.platform.core.Assert;
import com.canoo.platform.client.PlatformClient;
import com.canoo.platform.core.DolphinRuntimeException;
import com.canoo.platform.remoting.client.ClientContext;
import com.canoo.platform.remoting.client.ClientContextFactory;
import com.canoo.platform.remoting.client.ClientInitializationException;
import com.canoo.platform.remoting.client.javafx.FxToolkit;
import java.net.MalformedURLException;
import java.net.URL;
import java.util.Collections;
import java.util.List;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.CopyOnWriteArrayList;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicBoolean;
import javafx.application.Application;
import javafx.application.Platform;
import javafx.stage.Stage;
import org.apiguardian.api.API;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@API(since="0.x", status=API.Status.MAINTAINED)
public abstract class DolphinPlatformApplication
extends Application {
    private static final Logger LOG = LoggerFactory.getLogger(DolphinPlatformApplication.class);
    private ClientContext clientContext;
    private ClientInitializationException initializationException;
    private final List<DolphinRuntimeException> runtimeExceptionsAtInitialization = new CopyOnWriteArrayList<DolphinRuntimeException>();
    private Stage primaryStage;
    private AtomicBoolean connectInProgress = new AtomicBoolean(false);

    protected abstract URL getServerEndpoint() throws MalformedURLException;

    private final ClientContext createClientContext() throws Exception {
        return ((ClientContextFactory)PlatformClient.getService(ClientContextFactory.class)).create(PlatformClient.getClientConfiguration(), this.getServerEndpoint().toURI());
    }

    public final void init() throws Exception {
        FxToolkit.init();
        this.applicationInit();
        PlatformClient.getClientConfiguration().setUncaughtExceptionHandler((thread, exception) -> PlatformClient.getClientConfiguration().getUiExecutor().execute(() -> {
            Assert.requireNonNull((Object)thread, (String)"thread");
            Assert.requireNonNull((Object)exception, (String)"exception");
            if (this.connectInProgress.get()) {
                this.runtimeExceptionsAtInitialization.add(new DolphinRuntimeException(thread, "Unhandled error in Dolphin Platform background thread", exception));
            } else {
                this.onRuntimeError(this.primaryStage, new DolphinRuntimeException(thread, "Unhandled error in Dolphin Platform background thread", exception));
            }
        }));
        try {
            this.clientContext = this.createClientContext();
            Assert.requireNonNull((Object)this.clientContext, (String)"clientContext");
            this.connectInProgress.set(true);
            this.clientContext.connect().get(30000L, TimeUnit.MILLISECONDS);
        }
        catch (ClientInitializationException e) {
            this.initializationException = e;
        }
        catch (Exception e) {
            this.initializationException = new ClientInitializationException("Can not initialize Dolphin Platform Context", (Throwable)e);
        }
        finally {
            this.connectInProgress.set(false);
        }
    }

    protected void applicationInit() throws Exception {
    }

    protected abstract void start(Stage var1, ClientContext var2) throws Exception;

    public final void start(Stage primaryStage) throws Exception {
        Assert.requireNonNull((Object)primaryStage, (String)"primaryStage");
        this.primaryStage = primaryStage;
        if (this.initializationException == null) {
            if (this.clientContext != null) {
                try {
                    this.start(primaryStage, this.clientContext);
                }
                catch (Exception e) {
                    this.handleInitializationError(primaryStage, new ClientInitializationException("Error in application start!", (Throwable)e));
                }
            } else {
                this.handleInitializationError(primaryStage, new ClientInitializationException("No clientContext was created!"));
            }
        } else {
            this.handleInitializationError(primaryStage, this.initializationException);
        }
    }

    protected final CompletableFuture<Void> disconnect() {
        if (this.clientContext != null) {
            return this.clientContext.disconnect();
        }
        CompletableFuture<Void> result = new CompletableFuture<Void>();
        result.complete(null);
        return result;
    }

    public final void stop() throws Exception {
        this.disconnect();
    }

    protected final CompletableFuture<Void> reconnect(Stage primaryStage) {
        Assert.requireNonNull((Object)primaryStage, (String)"primaryStage");
        CompletableFuture<Void> result = new CompletableFuture<Void>();
        PlatformClient.getClientConfiguration().getBackgroundExecutor().execute(() -> {
            try {
                this.disconnect().get(1000L, TimeUnit.MILLISECONDS);
            }
            catch (Exception e) {
                LOG.warn("Can not disconnect. Trying to reconnect anyway.");
            }
            try {
                if (this.clientContext == null) {
                    this.clientContext = this.createClientContext();
                }
                Assert.requireNonNull((Object)this.clientContext, (String)"clientContext");
                this.connectInProgress.set(true);
                this.clientContext.connect().get(3000L, TimeUnit.MILLISECONDS);
                Platform.runLater(() -> {
                    try {
                        this.start(primaryStage, this.clientContext);
                    }
                    catch (Exception e) {
                        this.handleInitializationError(primaryStage, new ClientInitializationException("Error in application reconnect", (Throwable)e));
                    }
                });
            }
            catch (Exception e) {
                Platform.runLater(() -> this.handleInitializationError(primaryStage, new ClientInitializationException("Error in application reconnect", (Throwable)e)));
            }
            finally {
                this.connectInProgress.set(false);
            }
            result.complete(null);
        });
        return result;
    }

    protected void onInitializationError(Stage primaryStage, ClientInitializationException initializationException, Iterable<DolphinRuntimeException> possibleCauses) {
        LOG.error("Dolphin Platform initialization error", (Throwable)initializationException);
        for (DolphinRuntimeException cause : possibleCauses) {
            LOG.error("Possible cause", (Throwable)cause);
        }
        Platform.exit();
    }

    private final void handleInitializationError(Stage primaryStage, ClientInitializationException initializationException) {
        List<DolphinRuntimeException> possibleCauses = Collections.unmodifiableList(this.runtimeExceptionsAtInitialization);
        this.runtimeExceptionsAtInitialization.clear();
        this.onInitializationError(primaryStage, initializationException, possibleCauses);
    }

    protected void onRuntimeError(Stage primaryStage, DolphinRuntimeException runtimeException) {
        Assert.requireNonNull((Object)runtimeException, (String)"runtimeException");
        LOG.error("Dolphin Platform runtime error in thread " + runtimeException.getThread().getName(), (Throwable)runtimeException);
        Platform.exit();
    }
}

