/*
 * Decompiled with CFR 0.152.
 */
package com.canoo.platform.remoting.client.javafx;

import com.canoo.dp.impl.platform.core.Assert;
import com.canoo.platform.remoting.ListChangeEvent;
import com.canoo.platform.remoting.ObservableList;
import com.canoo.platform.remoting.Property;
import com.canoo.platform.remoting.client.javafx.FXBinder;
import javafx.beans.property.BooleanProperty;
import javafx.beans.property.DoubleProperty;
import javafx.beans.property.FloatProperty;
import javafx.beans.property.IntegerProperty;
import javafx.beans.property.LongProperty;
import javafx.beans.property.ObjectProperty;
import javafx.beans.property.SimpleBooleanProperty;
import javafx.beans.property.SimpleDoubleProperty;
import javafx.beans.property.SimpleFloatProperty;
import javafx.beans.property.SimpleIntegerProperty;
import javafx.beans.property.SimpleLongProperty;
import javafx.beans.property.SimpleObjectProperty;
import javafx.beans.property.SimpleStringProperty;
import javafx.beans.property.StringProperty;
import javafx.collections.FXCollections;
import org.apiguardian.api.API;

@API(since="0.x", status=API.Status.MAINTAINED)
public class FXWrapper {
    private static boolean listenToFx = true;
    private static boolean listenToDolphin = true;

    private FXWrapper() {
    }

    public static DoubleProperty wrapDoubleProperty(Property<Double> dolphinProperty) {
        Assert.requireNonNull(dolphinProperty, (String)"dolphinProperty");
        SimpleDoubleProperty property = new SimpleDoubleProperty();
        FXBinder.bind((DoubleProperty)property).bidirectionalToNumeric(dolphinProperty);
        return property;
    }

    public static FloatProperty wrapFloatProperty(Property<Float> dolphinProperty) {
        Assert.requireNonNull(dolphinProperty, (String)"dolphinProperty");
        SimpleFloatProperty property = new SimpleFloatProperty();
        FXBinder.bind((FloatProperty)property).bidirectionalToNumeric(dolphinProperty);
        return property;
    }

    public static IntegerProperty wrapIntProperty(Property<Integer> dolphinProperty) {
        Assert.requireNonNull(dolphinProperty, (String)"dolphinProperty");
        SimpleIntegerProperty property = new SimpleIntegerProperty();
        FXBinder.bind((IntegerProperty)property).bidirectionalToNumeric(dolphinProperty);
        return property;
    }

    public static LongProperty wrapLongProperty(Property<Long> dolphinProperty) {
        Assert.requireNonNull(dolphinProperty, (String)"dolphinProperty");
        SimpleLongProperty property = new SimpleLongProperty();
        FXBinder.bind((LongProperty)property).bidirectionalToNumeric(dolphinProperty);
        return property;
    }

    public static BooleanProperty wrapBooleanProperty(Property<Boolean> dolphinProperty) {
        Assert.requireNonNull(dolphinProperty, (String)"dolphinProperty");
        SimpleBooleanProperty property = new SimpleBooleanProperty();
        FXBinder.bind(property).bidirectionalTo(dolphinProperty);
        return property;
    }

    public static StringProperty wrapStringProperty(Property<String> dolphinProperty) {
        Assert.requireNonNull(dolphinProperty, (String)"dolphinProperty");
        SimpleStringProperty property = new SimpleStringProperty();
        FXBinder.bind(property).bidirectionalTo(dolphinProperty);
        return property;
    }

    public static <T> ObjectProperty<T> wrapObjectProperty(Property<T> dolphinProperty) {
        Assert.requireNonNull(dolphinProperty, (String)"dolphinProperty");
        SimpleObjectProperty property = new SimpleObjectProperty();
        FXBinder.bind(property).bidirectionalTo(dolphinProperty);
        return property;
    }

    public static <T> javafx.collections.ObservableList<T> wrapList(ObservableList<T> dolphinList) {
        Assert.requireNonNull(dolphinList, (String)"dolphinList");
        javafx.collections.ObservableList list = FXCollections.observableArrayList(dolphinList);
        list.addListener(c -> {
            if (listenToFx) {
                listenToDolphin = false;
                while (c.next()) {
                    if (!c.wasAdded() && !c.wasRemoved() && !c.wasReplaced()) continue;
                    for (Object removed : c.getRemoved()) {
                        dolphinList.remove(removed);
                    }
                    for (Object added : c.getAddedSubList()) {
                        dolphinList.add(list.indexOf(added), added);
                    }
                }
                listenToDolphin = true;
            }
        });
        dolphinList.onChanged(e -> {
            if (listenToDolphin) {
                listenToFx = false;
                for (ListChangeEvent.Change c : e.getChanges()) {
                    if (c.isAdded()) {
                        for (int i = c.getFrom(); i < c.getTo(); ++i) {
                            list.add(i, dolphinList.get(i));
                        }
                        continue;
                    }
                    if (!c.isRemoved()) continue;
                    int index = c.getFrom();
                    list.remove(index, index + c.getRemovedElements().size());
                }
                listenToFx = true;
            }
        });
        return list;
    }
}

