/*
 * Decompiled with CFR 0.152.
 */
package com.canoo.platform.remoting.client.javafx.view;

import com.canoo.dp.impl.platform.core.Assert;
import com.canoo.platform.remoting.client.ClientContext;
import com.canoo.platform.remoting.client.ControllerProxy;
import com.canoo.platform.remoting.client.Param;
import java.util.concurrent.CompletableFuture;
import javafx.beans.property.ReadOnlyBooleanProperty;
import javafx.beans.property.ReadOnlyBooleanWrapper;
import javafx.beans.property.ReadOnlyObjectProperty;
import javafx.beans.property.ReadOnlyObjectWrapper;
import javafx.scene.Node;
import javafx.scene.Parent;
import org.apiguardian.api.API;

@API(since="0.x", status=API.Status.MAINTAINED)
public abstract class AbstractViewController<M> {
    private ControllerProxy<M> controllerProxy;
    private final ReadOnlyBooleanWrapper actionInProcess = new ReadOnlyBooleanWrapper(false);
    private final ReadOnlyObjectWrapper<M> model = new ReadOnlyObjectWrapper();
    private final ClientContext clientContext;

    public AbstractViewController(ClientContext clientContext, String controllerName) {
        Assert.requireNonBlank((String)controllerName, (String)"controllerName");
        this.clientContext = (ClientContext)Assert.requireNonNull((Object)clientContext, (String)"clientContext");
        clientContext.createController(controllerName).whenComplete((c, e) -> {
            if (e != null) {
                this.onInitializationException((Throwable)e);
            } else {
                try {
                    this.controllerProxy = c;
                    this.model.set(c.getModel());
                    this.init();
                }
                catch (Exception exception) {
                    this.onInitializationException(exception);
                }
            }
        });
    }

    protected abstract void init();

    public CompletableFuture<Void> destroy() {
        CompletableFuture<Void> ret;
        if (this.controllerProxy != null) {
            ret = this.controllerProxy.destroy();
            this.controllerProxy = null;
        } else {
            ret = new CompletableFuture<Void>();
            ret.complete(null);
        }
        return ret;
    }

    protected CompletableFuture<Void> invoke(String actionName, Param ... params) {
        Assert.requireNonBlank((String)actionName, (String)"actionName");
        this.actionInProcess.set(true);
        return this.controllerProxy.invoke(actionName, params).whenComplete((v, e) -> {
            try {
                if (e != null) {
                    this.onInvocationException((Throwable)e);
                }
            }
            finally {
                this.actionInProcess.set(false);
            }
        });
    }

    public boolean isActionInProcess() {
        return this.actionInProcess.get();
    }

    public ReadOnlyBooleanProperty actionInProcessProperty() {
        return this.actionInProcess.getReadOnlyProperty();
    }

    public M getModel() {
        return (M)this.model.get();
    }

    public ReadOnlyObjectProperty<M> modelProperty() {
        return this.model.getReadOnlyProperty();
    }

    protected void onInitializationException(Throwable t) {
    }

    protected void onInvocationException(Throwable e) {
    }

    public ClientContext getClientContext() {
        return this.clientContext;
    }

    public abstract Node getRootNode();

    public Parent getParent() {
        Node rootNode = this.getRootNode();
        if (rootNode == null) {
            throw new NullPointerException("The root node is null");
        }
        if (!(rootNode instanceof Parent)) {
            throw new IllegalStateException("The root node of this view is not a Parent");
        }
        return (Parent)rootNode;
    }

    protected ControllerProxy<M> getControllerProxy() {
        return this.controllerProxy;
    }
}

