/*
 * Decompiled with CFR 0.152.
 */
package com.canoo.platform.remoting.client.javafx.window;

import com.canoo.dp.impl.platform.core.Assert;
import com.canoo.platform.core.functional.Subscription;
import com.canoo.platform.remoting.client.javafx.view.AbstractViewController;
import javafx.event.EventHandler;
import javafx.scene.Scene;
import javafx.stage.Stage;
import javafx.stage.Window;
import javafx.stage.WindowEvent;
import org.apiguardian.api.API;

@API(since="0.x", status=API.Status.MAINTAINED)
public class DolphinWindowUtils {
    public static <M> Subscription destroyOnClose(Window window, AbstractViewController<M> viewBinder) {
        Assert.requireNonNull((Object)window, (String)"window");
        Assert.requireNonNull(viewBinder, (String)"viewBinder");
        EventHandler handler = e -> viewBinder.destroy();
        window.addEventFilter(WindowEvent.WINDOW_HIDDEN, handler);
        return () -> window.removeEventFilter(WindowEvent.WINDOW_HIDDEN, handler);
    }

    public static final <M> Window createWindow(AbstractViewController<M> viewBinder) {
        Assert.requireNonNull(viewBinder, (String)"viewBinder");
        return new DolphinWindow<M>(viewBinder);
    }

    public static final <M> Stage createStage(AbstractViewController<M> viewBinder) {
        Assert.requireNonNull(viewBinder, (String)"viewBinder");
        return new DolphinStage<M>(viewBinder);
    }

    private static class DolphinWindow<M>
    extends Window {
        public DolphinWindow(AbstractViewController<M> viewBinder) {
            Assert.requireNonNull(viewBinder, (String)"viewBinder");
            DolphinWindowUtils.destroyOnClose(this, viewBinder);
            this.setScene(new Scene(viewBinder.getParent()));
        }
    }

    private static class DolphinStage<M>
    extends Stage {
        public DolphinStage(AbstractViewController<M> viewBinder) {
            Assert.requireNonNull(viewBinder, (String)"viewBinder");
            DolphinWindowUtils.destroyOnClose((Window)this, viewBinder);
            this.setScene(new Scene(viewBinder.getParent()));
        }
    }
}

