/*
 * Decompiled with CFR 0.152.
 */
package com.canoo.dp.impl.client;

import com.canoo.dp.impl.client.ClientBeanBuilderImpl;
import com.canoo.dp.impl.client.ClientEventDispatcher;
import com.canoo.dp.impl.client.ClientPresentationModelBuilderFactory;
import com.canoo.dp.impl.client.ControllerProxyFactory;
import com.canoo.dp.impl.client.DolphinCommandHandler;
import com.canoo.dp.impl.client.legacy.ClientModelStore;
import com.canoo.dp.impl.client.legacy.DefaultModelSynchronizer;
import com.canoo.dp.impl.client.legacy.communication.AbstractClientConnector;
import com.canoo.dp.impl.platform.core.Assert;
import com.canoo.dp.impl.remoting.BeanBuilder;
import com.canoo.dp.impl.remoting.BeanManagerImpl;
import com.canoo.dp.impl.remoting.BeanRepository;
import com.canoo.dp.impl.remoting.BeanRepositoryImpl;
import com.canoo.dp.impl.remoting.ClassRepository;
import com.canoo.dp.impl.remoting.ClassRepositoryImpl;
import com.canoo.dp.impl.remoting.Converters;
import com.canoo.dp.impl.remoting.EventDispatcher;
import com.canoo.dp.impl.remoting.ListMapper;
import com.canoo.dp.impl.remoting.PresentationModelBuilderFactory;
import com.canoo.dp.impl.remoting.collections.ListMapperImpl;
import com.canoo.dp.impl.remoting.commands.CreateContextCommand;
import com.canoo.dp.impl.remoting.commands.DestroyContextCommand;
import com.canoo.dp.impl.remoting.legacy.communication.Command;
import com.canoo.dp.impl.remoting.legacy.core.ModelStore;
import com.canoo.platform.client.ClientConfiguration;
import com.canoo.platform.client.session.ClientSessionStore;
import com.canoo.platform.remoting.BeanManager;
import com.canoo.platform.remoting.DolphinRemotingException;
import com.canoo.platform.remoting.client.ClientContext;
import com.canoo.platform.remoting.client.ClientInitializationException;
import com.canoo.platform.remoting.client.ControllerInitalizationException;
import com.canoo.platform.remoting.client.ControllerProxy;
import java.net.URI;
import java.util.concurrent.CompletableFuture;
import java.util.function.BiFunction;
import java.util.function.Function;
import java.util.function.Supplier;
import org.apiguardian.api.API;

@API(since="0.x", status=API.Status.INTERNAL)
public class ClientContextImpl
implements ClientContext {
    private final ClientConfiguration clientConfiguration;
    private final Function<ClientModelStore, AbstractClientConnector> connectorProvider;
    private final URI endpoint;
    private final ClientSessionStore clientSessionStore;
    private final AbstractClientConnector clientConnector;
    private final ClientModelStore modelStore;
    @Deprecated
    private final BeanManager clientBeanManager;
    private final ControllerProxyFactory controllerProxyFactory;
    private final DolphinCommandHandler dolphinCommandHandler;

    public ClientContextImpl(ClientConfiguration clientConfiguration, URI endpoint, Function<ClientModelStore, AbstractClientConnector> connectorProvider, ClientSessionStore clientSessionStore) {
        this.clientConfiguration = (ClientConfiguration)Assert.requireNonNull((Object)clientConfiguration, (String)"clientConfiguration");
        this.connectorProvider = (Function)Assert.requireNonNull(connectorProvider, (String)"connectorProvider");
        this.clientSessionStore = (ClientSessionStore)Assert.requireNonNull((Object)clientSessionStore, (String)"clientSessionStore");
        this.endpoint = (URI)Assert.requireNonNull((Object)endpoint, (String)"endpoint");
        DefaultModelSynchronizer defaultModelSynchronizer = new DefaultModelSynchronizer(new Supplier<AbstractClientConnector>(){

            @Override
            public AbstractClientConnector get() {
                return ClientContextImpl.this.clientConnector;
            }
        });
        this.modelStore = new ClientModelStore(defaultModelSynchronizer);
        this.clientConnector = connectorProvider.apply(this.modelStore);
        ClientEventDispatcher dispatcher = new ClientEventDispatcher(this.modelStore);
        BeanRepositoryImpl beanRepository = new BeanRepositoryImpl((ModelStore)this.modelStore, (EventDispatcher)dispatcher);
        Converters converters = new Converters((BeanRepository)beanRepository);
        ClientPresentationModelBuilderFactory builderFactory = new ClientPresentationModelBuilderFactory(this.modelStore);
        ClassRepositoryImpl classRepository = new ClassRepositoryImpl((ModelStore)this.modelStore, converters, (PresentationModelBuilderFactory)builderFactory);
        this.dolphinCommandHandler = new DolphinCommandHandler(this.clientConnector);
        this.controllerProxyFactory = new ControllerProxyFactory(this.dolphinCommandHandler, this.clientConnector, this.modelStore, (BeanRepository)beanRepository, (EventDispatcher)dispatcher, converters);
        this.clientBeanManager = new BeanManagerImpl((BeanRepository)beanRepository, (BeanBuilder)new ClientBeanBuilderImpl((ClassRepository)classRepository, (BeanRepository)beanRepository, (ListMapper)new ListMapperImpl((ModelStore)this.modelStore, (ClassRepository)classRepository, (BeanRepository)beanRepository, (PresentationModelBuilderFactory)builderFactory, (EventDispatcher)dispatcher), builderFactory, (EventDispatcher)dispatcher));
    }

    protected DolphinCommandHandler getDolphinCommandHandler() {
        return this.dolphinCommandHandler;
    }

    @Override
    public synchronized <T> CompletableFuture<ControllerProxy<T>> createController(String name) {
        Assert.requireNonBlank((String)name, (String)"name");
        if (this.controllerProxyFactory == null) {
            throw new IllegalStateException("connect was not called!");
        }
        return this.controllerProxyFactory.create(name).handle(new BiFunction<ControllerProxy<T>, Throwable, ControllerProxy<T>>(){

            @Override
            public ControllerProxy<T> apply(ControllerProxy<T> controllerProxy, Throwable throwable) {
                if (throwable != null) {
                    throw new ControllerInitalizationException(throwable);
                }
                return controllerProxy;
            }
        });
    }

    @Override
    public synchronized BeanManager getBeanManager() {
        return this.clientBeanManager;
    }

    @Override
    public synchronized CompletableFuture<Void> disconnect() {
        final CompletableFuture<Void> result = new CompletableFuture<Void>();
        this.clientConfiguration.getBackgroundExecutor().execute(new Runnable(){

            @Override
            public void run() {
                ClientContextImpl.this.dolphinCommandHandler.invokeDolphinCommand((Command)new DestroyContextCommand()).handle(new BiFunction<Void, Throwable, Object>(){

                    @Override
                    public Object apply(Void aVoid, Throwable throwable) {
                        ClientContextImpl.this.clientConnector.disconnect();
                        ClientContextImpl.this.clientSessionStore.resetSession(ClientContextImpl.this.endpoint);
                        if (throwable != null) {
                            result.completeExceptionally((Throwable)new DolphinRemotingException("Can't disconnect", throwable));
                        } else {
                            result.complete(null);
                        }
                        return null;
                    }
                });
            }
        });
        return result;
    }

    @Override
    public CompletableFuture<Void> connect() {
        final CompletableFuture<Void> result = new CompletableFuture<Void>();
        this.clientConnector.connect();
        this.clientConfiguration.getBackgroundExecutor().execute(new Runnable(){

            @Override
            public void run() {
                ClientContextImpl.this.dolphinCommandHandler.invokeDolphinCommand((Command)new CreateContextCommand()).handle(new BiFunction<Void, Throwable, Void>(){

                    @Override
                    public Void apply(Void aVoid, Throwable throwable) {
                        if (throwable != null) {
                            result.completeExceptionally(new ClientInitializationException("Can't call init action!", throwable));
                        }
                        result.complete(null);
                        return null;
                    }
                });
            }
        });
        return result;
    }

    @Override
    public String getClientId() {
        return this.clientSessionStore.getClientIdentifierForUrl(this.endpoint);
    }
}

