/*
 * Decompiled with CFR 0.152.
 */
package com.canoo.dp.impl.client;

import com.canoo.dp.impl.client.ClientControllerActionCallBean;
import com.canoo.dp.impl.client.legacy.ClientModelStore;
import com.canoo.dp.impl.remoting.BeanRepository;
import com.canoo.dp.impl.remoting.Converters;
import com.canoo.dp.impl.remoting.DolphinEventHandler;
import com.canoo.dp.impl.remoting.EventDispatcher;
import com.canoo.dp.impl.remoting.InternalAttributesBean;
import com.canoo.dp.impl.remoting.legacy.core.PresentationModel;
import com.canoo.platform.remoting.client.Param;
import org.apiguardian.api.API;

@API(since="0.x", status=API.Status.INTERNAL)
public class ClientPlatformBeanRepository {
    private final ClientModelStore modelStore;
    private final Converters converters;
    private InternalAttributesBean internalAttributesBean;

    public ClientPlatformBeanRepository(ClientModelStore modelStore, final BeanRepository beanRepository, EventDispatcher dispatcher, Converters converters) {
        this.modelStore = modelStore;
        this.converters = converters;
        dispatcher.onceInternalAttributesBeanAddedHandler(new DolphinEventHandler(){

            public void onEvent(PresentationModel model) {
                ClientPlatformBeanRepository.this.internalAttributesBean = new InternalAttributesBean(beanRepository, model);
            }
        });
    }

    public ClientControllerActionCallBean createControllerActionCallBean(String controllerId, String actionName, Param ... params) {
        return new ClientControllerActionCallBean(this.modelStore, this.converters, controllerId, actionName, params);
    }

    public InternalAttributesBean getInternalAttributesBean() {
        if (this.internalAttributesBean == null) {
            throw new IllegalStateException("InternalAttributesBean was not initialized yet");
        }
        return this.internalAttributesBean;
    }
}

