/*
 * Decompiled with CFR 0.152.
 */
package com.canoo.dp.impl.client;

import com.canoo.dp.impl.client.ClientPlatformBeanRepository;
import com.canoo.dp.impl.client.ControllerProxyImpl;
import com.canoo.dp.impl.client.DolphinCommandHandler;
import com.canoo.dp.impl.client.legacy.ClientModelStore;
import com.canoo.dp.impl.client.legacy.communication.AbstractClientConnector;
import com.canoo.dp.impl.platform.core.Assert;
import com.canoo.dp.impl.remoting.BeanRepository;
import com.canoo.dp.impl.remoting.Converters;
import com.canoo.dp.impl.remoting.EventDispatcher;
import com.canoo.dp.impl.remoting.InternalAttributesBean;
import com.canoo.dp.impl.remoting.commands.CreateControllerCommand;
import com.canoo.dp.impl.remoting.legacy.communication.Command;
import com.canoo.platform.remoting.client.ControllerProxy;
import java.util.concurrent.CompletableFuture;
import java.util.function.Function;
import org.apiguardian.api.API;

@API(since="0.x", status=API.Status.INTERNAL)
public class ControllerProxyFactory {
    private final ClientPlatformBeanRepository platformBeanRepository;
    private final DolphinCommandHandler dolphinCommandHandler;
    private final AbstractClientConnector clientConnector;
    private final Converters converters;

    public ControllerProxyFactory(DolphinCommandHandler dolphinCommandHandler, AbstractClientConnector clientConnector, ClientModelStore modelStore, BeanRepository beanRepository, EventDispatcher dispatcher, Converters converters) {
        this.converters = (Converters)Assert.requireNonNull((Object)converters, (String)"converters");
        this.platformBeanRepository = new ClientPlatformBeanRepository(modelStore, beanRepository, dispatcher, converters);
        this.dolphinCommandHandler = (DolphinCommandHandler)Assert.requireNonNull((Object)dolphinCommandHandler, (String)"dolphinCommandHandler");
        this.clientConnector = (AbstractClientConnector)Assert.requireNonNull((Object)clientConnector, (String)"clientConnector");
    }

    public <T> CompletableFuture<ControllerProxy<T>> create(String name) {
        return this.create(name, null);
    }

    public <T> CompletableFuture<ControllerProxy<T>> create(String name, String parentControllerId) {
        Assert.requireNonBlank((String)name, (String)"name");
        final InternalAttributesBean bean = this.platformBeanRepository.getInternalAttributesBean();
        CreateControllerCommand createControllerCommand = new CreateControllerCommand();
        createControllerCommand.setControllerName(name);
        if (parentControllerId != null) {
            createControllerCommand.setParentControllerId(parentControllerId);
        }
        return this.dolphinCommandHandler.invokeDolphinCommand((Command)createControllerCommand).thenApply(new Function<Void, ControllerProxy<T>>(){

            @Override
            public ControllerProxy<T> apply(Void aVoid) {
                return new ControllerProxyImpl<Object>(bean.getControllerId(), bean.getModel(), ControllerProxyFactory.this.clientConnector, ControllerProxyFactory.this.platformBeanRepository, ControllerProxyFactory.this, ControllerProxyFactory.this.converters);
            }
        });
    }
}

