/*
 * Decompiled with CFR 0.152.
 */
package com.canoo.dp.impl.client;

import com.canoo.dp.impl.client.ClientControllerActionCallBean;
import com.canoo.dp.impl.client.ClientPlatformBeanRepository;
import com.canoo.dp.impl.client.ControllerProxyFactory;
import com.canoo.dp.impl.client.legacy.communication.AbstractClientConnector;
import com.canoo.dp.impl.client.legacy.communication.OnFinishedHandler;
import com.canoo.dp.impl.platform.core.Assert;
import com.canoo.dp.impl.remoting.Converters;
import com.canoo.dp.impl.remoting.InternalAttributesBean;
import com.canoo.dp.impl.remoting.MappingException;
import com.canoo.dp.impl.remoting.commands.CallActionCommand;
import com.canoo.dp.impl.remoting.commands.DestroyControllerCommand;
import com.canoo.dp.impl.remoting.legacy.communication.Command;
import com.canoo.platform.remoting.client.ControllerActionException;
import com.canoo.platform.remoting.client.ControllerInitalizationException;
import com.canoo.platform.remoting.client.ControllerProxy;
import com.canoo.platform.remoting.client.Param;
import com.canoo.platform.remoting.spi.converter.ValueConverterException;
import java.util.List;
import java.util.Map;
import java.util.concurrent.CompletableFuture;
import java.util.function.BiFunction;
import java.util.stream.Collectors;
import org.apiguardian.api.API;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@API(since="0.x", status=API.Status.INTERNAL)
public class ControllerProxyImpl<T>
implements ControllerProxy<T> {
    private static final Logger LOG = LoggerFactory.getLogger(ControllerProxyImpl.class);
    private final String controllerId;
    private final AbstractClientConnector clientConnector;
    private final ClientPlatformBeanRepository platformBeanRepository;
    private final ControllerProxyFactory controllerProxyFactory;
    private final Converters converters;
    private T model;
    private volatile boolean destroyed = false;

    public ControllerProxyImpl(String controllerId, T model, AbstractClientConnector clientConnector, ClientPlatformBeanRepository platformBeanRepository, ControllerProxyFactory controllerProxyFactory, Converters converters) {
        this.clientConnector = (AbstractClientConnector)Assert.requireNonNull((Object)clientConnector, (String)"clientConnector");
        this.controllerId = Assert.requireNonBlank((String)controllerId, (String)"controllerId");
        this.controllerProxyFactory = (ControllerProxyFactory)Assert.requireNonNull((Object)controllerProxyFactory, (String)"controllerProxyFactory");
        this.model = Assert.requireNonNull(model, (String)"model");
        this.platformBeanRepository = (ClientPlatformBeanRepository)Assert.requireNonNull((Object)platformBeanRepository, (String)"platformBeanRepository");
        this.converters = (Converters)Assert.requireNonNull((Object)converters, (String)"converters");
    }

    @Override
    public T getModel() {
        return this.model;
    }

    @Override
    public CompletableFuture<Void> invoke(String actionName, Map<String, ?> params) {
        List<Param> paramList = params.entrySet().stream().map(e -> new Param((String)e.getKey(), e.getValue())).collect(Collectors.toList());
        return this.invoke(actionName, paramList.toArray(new Param[paramList.size()]));
    }

    @Override
    public CompletableFuture<Void> invoke(String actionName, Param ... params) {
        if (this.destroyed) {
            throw new IllegalStateException("The controller was already destroyed");
        }
        final ClientControllerActionCallBean bean = this.platformBeanRepository.createControllerActionCallBean(this.controllerId, actionName, params);
        CallActionCommand callActionCommand = new CallActionCommand();
        callActionCommand.setControllerId(this.controllerId);
        callActionCommand.setActionName(actionName);
        if (params != null) {
            for (Param param : params) {
                Object value = param.getValue();
                if (value == null) {
                    callActionCommand.addParam(param.getName(), null);
                    continue;
                }
                try {
                    callActionCommand.addParam(param.getName(), this.converters.getConverter(value.getClass()).convertToDolphin(value));
                }
                catch (ValueConverterException e) {
                    throw new MappingException("Error in value conversion of param '" + param.getName() + "' for action '" + actionName + "'", (Throwable)e);
                }
            }
        }
        final CompletableFuture<Void> result = new CompletableFuture<Void>();
        this.clientConnector.send((Command)callActionCommand, new OnFinishedHandler(){

            @Override
            public void onFinished() {
                if (bean.isError()) {
                    result.completeExceptionally(new ControllerActionException("Error on calling action on the server. Please check the server log."));
                } else {
                    result.complete(null);
                }
                bean.unregister();
            }
        });
        return result;
    }

    @Override
    public CompletableFuture<Void> destroy() {
        if (this.destroyed) {
            throw new IllegalStateException("The controller was already destroyed");
        }
        this.destroyed = true;
        InternalAttributesBean bean = this.platformBeanRepository.getInternalAttributesBean();
        final CompletableFuture<Void> ret = new CompletableFuture<Void>();
        DestroyControllerCommand destroyControllerCommand = new DestroyControllerCommand();
        destroyControllerCommand.setControllerId(this.controllerId);
        this.clientConnector.send((Command)destroyControllerCommand, new OnFinishedHandler(){

            @Override
            public void onFinished() {
                ControllerProxyImpl.this.model = null;
                ret.complete(null);
            }
        });
        return ret;
    }

    public <C> CompletableFuture<ControllerProxy<C>> createController(String name) {
        Assert.requireNonBlank((String)name, (String)"name");
        return this.controllerProxyFactory.create(name, this.controllerId).handle(new BiFunction<ControllerProxy<C>, Throwable, ControllerProxy<C>>(){

            @Override
            public ControllerProxy<C> apply(ControllerProxy<C> cControllerProxy, Throwable throwable) {
                if (throwable != null) {
                    throw new ControllerInitalizationException(throwable);
                }
                return cControllerProxy;
            }
        });
    }
}

