/*
 * Decompiled with CFR 0.152.
 */
package com.canoo.dp.impl.client;

import com.canoo.dp.impl.client.legacy.ClientModelStore;
import com.canoo.dp.impl.client.legacy.communication.AbstractClientConnector;
import com.canoo.dp.impl.client.legacy.communication.BlindCommandBatcher;
import com.canoo.dp.impl.platform.core.Assert;
import com.canoo.dp.impl.remoting.commands.DestroyContextCommand;
import com.canoo.dp.impl.remoting.legacy.communication.Codec;
import com.canoo.dp.impl.remoting.legacy.communication.Command;
import com.canoo.platform.client.ClientConfiguration;
import com.canoo.platform.core.http.HttpClient;
import com.canoo.platform.core.http.HttpResponse;
import com.canoo.platform.core.http.RequestMethod;
import com.canoo.platform.remoting.DolphinRemotingException;
import com.canoo.platform.remoting.client.RemotingExceptionHandler;
import java.net.URI;
import java.util.Collections;
import java.util.List;
import java.util.concurrent.atomic.AtomicBoolean;
import org.apiguardian.api.API;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@API(since="0.x", status=API.Status.INTERNAL)
public class DolphinPlatformHttpClientConnector
extends AbstractClientConnector {
    private static final Logger LOG = LoggerFactory.getLogger(DolphinPlatformHttpClientConnector.class);
    private final URI servletUrl;
    private final Codec codec;
    private final HttpClient client;
    private final AtomicBoolean disconnecting = new AtomicBoolean(false);

    public DolphinPlatformHttpClientConnector(URI servletUrl, ClientConfiguration configuration, ClientModelStore clientModelStore, Codec codec, RemotingExceptionHandler onException, HttpClient client) {
        super(clientModelStore, ((ClientConfiguration)Assert.requireNonNull((Object)configuration, (String)"configuration")).getUiExecutor(), new BlindCommandBatcher(), onException, configuration.getBackgroundExecutor());
        this.servletUrl = (URI)Assert.requireNonNull((Object)servletUrl, (String)"servletUrl");
        this.codec = (Codec)Assert.requireNonNull((Object)codec, (String)"codec");
        this.client = (HttpClient)Assert.requireNonNull((Object)client, (String)"client");
    }

    @Override
    public List<Command> transmit(List<Command> commands) throws DolphinRemotingException {
        Assert.requireNonNull(commands, (String)"commands");
        if (this.disconnecting.get()) {
            LOG.warn("Canceled communication based on disconnect");
            return Collections.emptyList();
        }
        for (Command command : commands) {
            if (!(command instanceof DestroyContextCommand)) continue;
            this.disconnecting.set(true);
        }
        try {
            String data = this.codec.encode(commands);
            String receivedContent = (String)((HttpResponse)this.client.request(this.servletUrl, RequestMethod.POST).withContent(data, "application/json;charset=utf-8").readString().execute().get()).getContent();
            return this.codec.decode(receivedContent);
        }
        catch (Exception e) {
            throw new DolphinRemotingException("Error in remoting layer", (Throwable)e);
        }
    }

    @Override
    public void connect() {
        this.disconnecting.set(false);
        super.connect();
    }

    @Override
    public void disconnect() {
        super.disconnect();
        this.disconnecting.set(false);
    }
}

