/*
 * Decompiled with CFR 0.152.
 */
package com.canoo.dp.impl.client.legacy.communication;

import com.canoo.dp.impl.client.legacy.ClientModelStore;
import com.canoo.dp.impl.client.legacy.communication.ClientResponseHandler;
import com.canoo.dp.impl.client.legacy.communication.CommandAndHandler;
import com.canoo.dp.impl.client.legacy.communication.HandlerType;
import com.canoo.dp.impl.client.legacy.communication.ICommandBatcher;
import com.canoo.dp.impl.client.legacy.communication.OnFinishedHandler;
import com.canoo.dp.impl.remoting.legacy.commands.InterruptLongPollCommand;
import com.canoo.dp.impl.remoting.legacy.commands.StartLongPollCommand;
import com.canoo.dp.impl.remoting.legacy.communication.Command;
import com.canoo.platform.remoting.DolphinRemotingException;
import com.canoo.platform.remoting.client.RemotingExceptionHandler;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.concurrent.Executor;
import java.util.concurrent.atomic.AtomicBoolean;
import org.apiguardian.api.API;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@API(since="0.x", status=API.Status.DEPRECATED)
public abstract class AbstractClientConnector {
    private static final Logger LOG = LoggerFactory.getLogger(AbstractClientConnector.class);
    private final Executor uiExecutor;
    private final Executor backgroundExecutor;
    private final RemotingExceptionHandler remotingExceptionHandler;
    private final ClientResponseHandler responseHandler;
    private final ICommandBatcher commandBatcher;
    protected final AtomicBoolean releaseNeeded = new AtomicBoolean(false);
    protected final AtomicBoolean connectedFlag = new AtomicBoolean(false);
    protected final AtomicBoolean useLongPolling = new AtomicBoolean(false);
    protected boolean connectionFlagForUiExecutor = false;
    private StartLongPollCommand pushListener;
    private InterruptLongPollCommand releaseCommand;

    protected AbstractClientConnector(ClientModelStore clientModelStore, Executor uiExecutor, ICommandBatcher commandBatcher, RemotingExceptionHandler remotingExceptionHandler, Executor backgroundExecutor) {
        this.uiExecutor = Objects.requireNonNull(uiExecutor);
        this.commandBatcher = Objects.requireNonNull(commandBatcher);
        this.remotingExceptionHandler = Objects.requireNonNull(remotingExceptionHandler);
        this.backgroundExecutor = Objects.requireNonNull(backgroundExecutor);
        this.responseHandler = new ClientResponseHandler(clientModelStore);
        this.pushListener = new StartLongPollCommand();
        this.releaseCommand = new InterruptLongPollCommand();
    }

    private void handleError(final Exception exception) {
        Objects.requireNonNull(exception);
        this.disconnect();
        this.uiExecutor.execute(new Runnable(){

            @Override
            public void run() {
                AbstractClientConnector.this.connectionFlagForUiExecutor = false;
                if (exception instanceof DolphinRemotingException) {
                    AbstractClientConnector.this.remotingExceptionHandler.handle((DolphinRemotingException)((Object)exception));
                } else {
                    AbstractClientConnector.this.remotingExceptionHandler.handle(new DolphinRemotingException("internal remoting error", (Throwable)exception));
                }
            }
        });
    }

    protected void commandProcessing() {
        boolean longPollingActivated = false;
        while (this.connectedFlag.get()) {
            try {
                final List<CommandAndHandler> toProcess = this.commandBatcher.getWaitingBatches().getVal();
                ArrayList<Command> commands = new ArrayList<Command>();
                for (CommandAndHandler c : toProcess) {
                    commands.add(c.getCommand());
                }
                if (LOG.isDebugEnabled()) {
                    StringBuffer buffer = new StringBuffer();
                    for (Command command : commands) {
                        buffer.append(command.getClass().getSimpleName());
                        buffer.append(", ");
                    }
                    LOG.trace("Sending {} commands to server: {}", (Object)commands.size(), (Object)buffer.substring(0, buffer.length() - 2));
                } else {
                    LOG.trace("Sending {} commands to server", (Object)commands.size());
                }
                final List<Command> answers = this.transmit(commands);
                this.uiExecutor.execute(new Runnable(){

                    @Override
                    public void run() {
                        AbstractClientConnector.this.processResults(answers, toProcess);
                    }
                });
            }
            catch (Exception e) {
                if (this.connectedFlag.get()) {
                    this.handleError(e);
                }
                LOG.warn("Remoting error based on broken connection in parallel request", (Throwable)e);
            }
            if (longPollingActivated || !this.useLongPolling.get()) continue;
            this.uiExecutor.execute(new Runnable(){

                @Override
                public void run() {
                    AbstractClientConnector.this.listen();
                }
            });
            longPollingActivated = true;
        }
    }

    protected abstract List<Command> transmit(List<Command> var1) throws DolphinRemotingException;

    public void send(Command command, OnFinishedHandler callback, HandlerType handlerType) {
        LOG.trace("Command of type {} should be withContent to server", (Object)command.getClass().getSimpleName());
        if (!this.connectedFlag.get()) {
            throw new IllegalStateException("Connection is broken");
        }
        if (!command.equals(this.pushListener)) {
            this.release();
        }
        CommandAndHandler handler = new CommandAndHandler(command, callback, handlerType);
        this.commandBatcher.batch(handler);
    }

    public void send(Command command, OnFinishedHandler callback) {
        this.send(command, callback, HandlerType.UI);
    }

    public void send(Command command) {
        this.send(command, null);
    }

    protected void processResults(List<? extends Command> response, List<CommandAndHandler> commandsAndHandlers) {
        if (LOG.isDebugEnabled() && response.size() > 0) {
            StringBuffer buffer = new StringBuffer();
            for (Command command : response) {
                buffer.append(command.getClass().getSimpleName());
                buffer.append(", ");
            }
            LOG.trace("Processing {} commands from server: {}", (Object)response.size(), (Object)buffer.substring(0, buffer.length() - 2));
        } else {
            LOG.trace("Processing {} commands from server", (Object)response.size());
        }
        for (Command command : response) {
            this.dispatchHandle(command);
        }
        OnFinishedHandler callback = commandsAndHandlers.get(0).getHandler();
        if (callback != null) {
            LOG.trace("Handling registered callback");
            try {
                callback.onFinished();
            }
            catch (Exception exception) {
                LOG.error("Error in handling callback", (Throwable)exception);
                throw exception;
            }
        }
    }

    public void dispatchHandle(Command command) {
        this.responseHandler.dispatchHandle(command);
    }

    protected void listen() {
        if (!this.connectedFlag.get() || this.releaseNeeded.get()) {
            return;
        }
        this.releaseNeeded.set(true);
        try {
            this.send((Command)this.pushListener, new OnFinishedHandler(){

                @Override
                public void onFinished() {
                    AbstractClientConnector.this.releaseNeeded.set(false);
                    AbstractClientConnector.this.listen();
                }
            });
        }
        catch (Exception e) {
            LOG.error("Error in sending long poll", (Throwable)e);
        }
    }

    protected void release() {
        if (!this.releaseNeeded.get()) {
            return;
        }
        this.releaseNeeded.set(false);
        this.backgroundExecutor.execute(new Runnable(){

            @Override
            public void run() {
                try {
                    ArrayList<InterruptLongPollCommand> releaseCommandList = new ArrayList<InterruptLongPollCommand>(Collections.singletonList(AbstractClientConnector.this.releaseCommand));
                    AbstractClientConnector.this.transmit(releaseCommandList);
                }
                catch (DolphinRemotingException e) {
                    AbstractClientConnector.this.handleError((Exception)((Object)e));
                }
            }
        });
    }

    public void connect(boolean longPoll) {
        if (this.connectedFlag.get()) {
            throw new IllegalStateException("Can not call connect on a connected connection");
        }
        this.connectedFlag.set(true);
        this.uiExecutor.execute(new Runnable(){

            @Override
            public void run() {
                AbstractClientConnector.this.connectionFlagForUiExecutor = true;
            }
        });
        this.backgroundExecutor.execute(new Runnable(){

            @Override
            public void run() {
                AbstractClientConnector.this.commandProcessing();
            }
        });
        this.useLongPolling.set(longPoll);
    }

    public void connect() {
        this.connect(true);
    }

    public void disconnect() {
        if (!this.connectedFlag.get()) {
            throw new IllegalStateException("Can not call disconnect on a disconnected connection");
        }
        this.connectedFlag.set(false);
        this.uiExecutor.execute(new Runnable(){

            @Override
            public void run() {
                AbstractClientConnector.this.connectionFlagForUiExecutor = false;
            }
        });
    }

    protected Command getReleaseCommand() {
        return this.releaseCommand;
    }
}

