/*
 * Decompiled with CFR 0.152.
 */
package com.canoo.dp.impl.client.legacy.communication;

import com.canoo.dp.impl.client.legacy.communication.CommandAndHandler;
import com.canoo.dp.impl.client.legacy.communication.CommandBatcher;
import com.canoo.dp.impl.remoting.legacy.communication.ValueChangedCommand;
import java.util.Arrays;
import java.util.LinkedList;
import java.util.List;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.concurrent.locks.Lock;
import java.util.concurrent.locks.ReentrantLock;
import org.apiguardian.api.API;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@API(since="0.x", status=API.Status.DEPRECATED)
public class BlindCommandBatcher
extends CommandBatcher {
    private static final Logger LOG = LoggerFactory.getLogger(BlindCommandBatcher.class);
    private ExecutorService executorService = Executors.newCachedThreadPool();
    private LinkedList<CommandAndHandler> commandsAndHandlers = new LinkedList();
    private Lock commandsAndHandlersLock = new ReentrantLock();
    private long deferMillis = 10L;
    private int maxBatchSize = 100;
    private boolean mergeValueChanges = false;
    protected final AtomicBoolean inProcess = new AtomicBoolean(false);
    protected final AtomicBoolean deferralNeeded = new AtomicBoolean(false);
    protected boolean shallWeEvenTryToMerge = false;

    @Override
    public boolean isEmpty() {
        return this.getWaitingBatches().length() < 1;
    }

    @Override
    public void batch(CommandAndHandler commandWithHandler) {
        LOG.trace("batching {} with {} handler", (Object)commandWithHandler.getCommand(), (Object)(commandWithHandler.getHandler() != null ? "" : "out"));
        if (this.canBeDropped(commandWithHandler)) {
            LOG.trace("dropping duplicate GetPresentationModelCommand");
            return;
        }
        this.commandsAndHandlersLock.lock();
        try {
            this.commandsAndHandlers.add(commandWithHandler);
        }
        finally {
            this.commandsAndHandlersLock.unlock();
        }
        if (commandWithHandler.isBatchable()) {
            this.deferralNeeded.set(true);
            if (this.inProcess.get()) {
                return;
            }
            this.processDeferred();
        } else {
            this.processBatch();
        }
    }

    protected boolean canBeDropped(CommandAndHandler commandWithHandler) {
        return false;
    }

    protected void processDeferred() {
        this.inProcess.set(true);
        this.executorService.execute(new Runnable(){

            @Override
            public void run() {
                for (int count = BlindCommandBatcher.this.getMaxBatchSize(); BlindCommandBatcher.this.deferralNeeded.get() && count > 0; --count) {
                    BlindCommandBatcher.this.deferralNeeded.set(false);
                    try {
                        Thread.sleep(BlindCommandBatcher.this.getDeferMillis());
                        continue;
                    }
                    catch (InterruptedException e) {
                        throw new RuntimeException("ERROR", e);
                    }
                }
                BlindCommandBatcher.this.processBatch();
                BlindCommandBatcher.this.inProcess.set(false);
            }
        });
    }

    protected void processBatch() {
        this.executorService.execute(new Runnable(){

            @Override
            public void run() {
                BlindCommandBatcher.this.getCommandsAndHandlersLock().lock();
                try {
                    CommandAndHandler last = BlindCommandBatcher.this.batchBlinds(BlindCommandBatcher.this.getCommandsAndHandlers());
                    if (last != null) {
                        BlindCommandBatcher.this.getWaitingBatches().add(Arrays.asList(last));
                    }
                    if (!BlindCommandBatcher.this.getCommandsAndHandlers().isEmpty()) {
                        BlindCommandBatcher.this.processBatch();
                    }
                }
                finally {
                    BlindCommandBatcher.this.getCommandsAndHandlersLock().unlock();
                }
            }
        });
    }

    protected CommandAndHandler batchBlinds(List<CommandAndHandler> queue) {
        if (queue.isEmpty()) {
            return null;
        }
        LinkedList<CommandAndHandler> blindCommands = new LinkedList<CommandAndHandler>();
        int counter = this.maxBatchSize;
        CommandAndHandler val = this.take(queue);
        this.shallWeEvenTryToMerge = false;
        while (val != null && val.isBatchable() && counter-- > 0) {
            this.addToBlindsOrMerge(blindCommands, val);
            val = counter != 0 ? this.take(queue) : null;
        }
        LOG.trace("batching {} blinds", (Object)blindCommands.size());
        if (!blindCommands.isEmpty()) {
            this.getWaitingBatches().add(blindCommands);
        }
        return val;
    }

    protected void addToBlindsOrMerge(List<CommandAndHandler> blindCommands, CommandAndHandler val) {
        if (!this.wasMerged(blindCommands, val)) {
            blindCommands.add(val);
            if (val.getCommand() instanceof ValueChangedCommand) {
                this.shallWeEvenTryToMerge = true;
            }
        }
    }

    protected boolean wasMerged(List<CommandAndHandler> blindCommands, CommandAndHandler val) {
        if (!this.mergeValueChanges) {
            return false;
        }
        if (!this.shallWeEvenTryToMerge) {
            return false;
        }
        if (blindCommands.isEmpty()) {
            return false;
        }
        if (val.getCommand() == null) {
            return false;
        }
        if (!(val.getCommand() instanceof ValueChangedCommand)) {
            return false;
        }
        ValueChangedCommand valCmd = (ValueChangedCommand)val.getCommand();
        this.shallWeEvenTryToMerge = true;
        if (blindCommands.get(blindCommands.size() - 1).getCommand() instanceof ValueChangedCommand) {
            ValueChangedCommand valueChangedCommand = (ValueChangedCommand)blindCommands.get(blindCommands.size() - 1).getCommand();
            if (valCmd.getAttributeId().equals(valueChangedCommand.getAttributeId())) {
                LOG.trace("merging value changed command for attribute {} with new values {}  -> {}", new Object[]{valueChangedCommand.getAttributeId(), valueChangedCommand.getNewValue(), valCmd.getNewValue()});
                valueChangedCommand.setNewValue(valCmd.getNewValue());
                return true;
            }
        }
        return false;
    }

    protected CommandAndHandler take(List<CommandAndHandler> intern) {
        if (intern.isEmpty()) {
            return null;
        }
        return intern.remove(0);
    }

    public List<CommandAndHandler> getCommandsAndHandlers() {
        return this.commandsAndHandlers;
    }

    public Lock getCommandsAndHandlersLock() {
        return this.commandsAndHandlersLock;
    }

    public long getDeferMillis() {
        return this.deferMillis;
    }

    public void setDeferMillis(long deferMillis) {
        this.deferMillis = deferMillis;
    }

    public int getMaxBatchSize() {
        return this.maxBatchSize;
    }

    public void setMaxBatchSize(int maxBatchSize) {
        this.maxBatchSize = maxBatchSize;
    }

    public void setMergeValueChanges(boolean mergeValueChanges) {
        this.mergeValueChanges = mergeValueChanges;
    }
}

