/*
 * Decompiled with CFR 0.152.
 */
package com.canoo.dp.impl.client.legacy.communication;

import com.canoo.dp.impl.client.legacy.ClientAttribute;
import com.canoo.dp.impl.client.legacy.ClientModelStore;
import com.canoo.dp.impl.client.legacy.ClientPresentationModel;
import com.canoo.dp.impl.remoting.legacy.communication.AttributeMetadataChangedCommand;
import com.canoo.dp.impl.remoting.legacy.communication.Command;
import com.canoo.dp.impl.remoting.legacy.communication.CreatePresentationModelCommand;
import com.canoo.dp.impl.remoting.legacy.communication.DeletePresentationModelCommand;
import com.canoo.dp.impl.remoting.legacy.communication.ValueChangedCommand;
import com.canoo.dp.impl.remoting.legacy.core.Attribute;
import com.canoo.dp.impl.remoting.legacy.core.PresentationModel;
import java.util.ArrayList;
import java.util.Map;
import java.util.Objects;
import org.apiguardian.api.API;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@API(since="0.x", status=API.Status.DEPRECATED)
public class ClientResponseHandler {
    private static final Logger LOG = LoggerFactory.getLogger(ClientResponseHandler.class);
    private final ClientModelStore clientModelStore;

    public ClientResponseHandler(ClientModelStore clientModelStore) {
        this.clientModelStore = Objects.requireNonNull(clientModelStore);
    }

    public void dispatchHandle(Command command) {
        if (command instanceof DeletePresentationModelCommand) {
            this.handleDeletePresentationModelCommand((DeletePresentationModelCommand)command);
        } else if (command instanceof CreatePresentationModelCommand) {
            this.handleCreatePresentationModelCommand((CreatePresentationModelCommand)command);
        } else if (command instanceof ValueChangedCommand) {
            this.handleValueChangedCommand((ValueChangedCommand)command);
        } else if (command instanceof AttributeMetadataChangedCommand) {
            this.handleAttributeMetadataChangedCommand((AttributeMetadataChangedCommand)command);
        } else {
            LOG.error("C: cannot withoutResult unknown command '{}'", (Object)command);
        }
    }

    private void handleDeletePresentationModelCommand(DeletePresentationModelCommand serverCommand) {
        ClientPresentationModel model = (ClientPresentationModel)this.clientModelStore.findPresentationModelById(serverCommand.getPmId());
        if (model == null) {
            return;
        }
        this.clientModelStore.delete(model);
    }

    private void handleCreatePresentationModelCommand(CreatePresentationModelCommand serverCommand) {
        if (this.clientModelStore.containsPresentationModel(serverCommand.getPmId())) {
            throw new IllegalStateException("There already is a presentation model with id '" + serverCommand.getPmId() + "' known to the client.");
        }
        ArrayList<ClientAttribute> attributes = new ArrayList<ClientAttribute>();
        for (Map attr : serverCommand.getAttributes()) {
            Object propertyName = attr.get("propertyName");
            Object value = attr.get("value");
            Object qualifier = attr.get("qualifier");
            Object id = attr.get("id");
            ClientAttribute attribute = new ClientAttribute(propertyName != null ? propertyName.toString() : null, value, qualifier != null ? qualifier.toString() : null);
            if (id != null && id.toString().endsWith("S")) {
                attribute.setId(id.toString());
            }
            attributes.add(attribute);
        }
        ClientPresentationModel model = new ClientPresentationModel(serverCommand.getPmId(), attributes);
        model.setPresentationModelType(serverCommand.getPmType());
        if (serverCommand.isClientSideOnly()) {
            model.setClientSideOnly(true);
        }
        this.clientModelStore.add(model);
        this.clientModelStore.updateQualifiers((PresentationModel)model);
    }

    private void handleValueChangedCommand(ValueChangedCommand serverCommand) {
        Attribute attribute = this.clientModelStore.findAttributeById(serverCommand.getAttributeId());
        if (attribute == null) {
            LOG.warn("C: attribute with id '{}' not found, cannot update to new value '{}'", (Object)serverCommand.getAttributeId(), serverCommand.getNewValue());
            return;
        }
        if (attribute.getValue() == null && serverCommand.getNewValue() == null || attribute.getValue() != null && serverCommand.getNewValue() != null && attribute.getValue().equals(serverCommand.getNewValue())) {
            return;
        }
        LOG.trace("C: updating '{}' id '{}' from '{}' to '{}' ", new Object[]{attribute.getPropertyName(), serverCommand.getAttributeId(), attribute.getValue(), serverCommand.getNewValue()});
        attribute.setValue(serverCommand.getNewValue());
    }

    private void handleAttributeMetadataChangedCommand(AttributeMetadataChangedCommand serverCommand) {
        ClientAttribute attribute = (ClientAttribute)this.clientModelStore.findAttributeById(serverCommand.getAttributeId());
        if (attribute == null) {
            return;
        }
        if (serverCommand.getMetadataName() != null && serverCommand.getMetadataName().equals("value")) {
            attribute.setValue(serverCommand.getValue());
        }
        if (serverCommand.getMetadataName() != null && serverCommand.getMetadataName().equals("qualifier")) {
            if (serverCommand.getValue() == null) {
                attribute.setQualifier(null);
            } else {
                attribute.setQualifier(serverCommand.getValue().toString());
            }
        }
    }
}

