/*
 * Decompiled with CFR 0.152.
 */
package com.canoo.dp.impl.remoting;

import com.canoo.dp.impl.platform.core.Assert;
import com.canoo.dp.impl.remoting.BeanBuilder;
import com.canoo.dp.impl.remoting.BeanRepository;
import com.canoo.dp.impl.remoting.ClassRepository;
import com.canoo.dp.impl.remoting.DolphinEventHandler;
import com.canoo.dp.impl.remoting.EventDispatcher;
import com.canoo.dp.impl.remoting.ListMapper;
import com.canoo.dp.impl.remoting.PresentationModelBuilder;
import com.canoo.dp.impl.remoting.PresentationModelBuilderFactory;
import com.canoo.dp.impl.remoting.UpdateSource;
import com.canoo.dp.impl.remoting.info.ClassInfo;
import com.canoo.dp.impl.remoting.info.PropertyInfo;
import com.canoo.dp.impl.remoting.legacy.core.Attribute;
import com.canoo.dp.impl.remoting.legacy.core.PresentationModel;
import com.canoo.platform.core.DolphinRuntimeException;
import com.canoo.platform.remoting.ObservableList;
import com.canoo.platform.remoting.Property;
import org.apiguardian.api.API;

@API(since="0.x", status=API.Status.INTERNAL)
public abstract class AbstractBeanBuilder
implements BeanBuilder {
    private final ClassRepository classRepository;
    private final BeanRepository beanRepository;
    private final ListMapper listMapper;
    private final PresentationModelBuilderFactory builderFactory;

    public AbstractBeanBuilder(final ClassRepository classRepository, BeanRepository beanRepository, ListMapper listMapper, PresentationModelBuilderFactory builderFactory, EventDispatcher dispatcher) {
        this.classRepository = (ClassRepository)Assert.requireNonNull((Object)classRepository, (String)"classRepository");
        this.beanRepository = (BeanRepository)Assert.requireNonNull((Object)beanRepository, (String)"beanRepository");
        this.listMapper = listMapper;
        this.builderFactory = (PresentationModelBuilderFactory)Assert.requireNonNull((Object)builderFactory, (String)"builderFactory");
        dispatcher.addAddedHandler(new DolphinEventHandler(){

            @Override
            public void onEvent(PresentationModel model) {
                Assert.requireNonNull((Object)model, (String)"model");
                ClassInfo classInfo = classRepository.getClassInfo(model.getPresentationModelType());
                Assert.requireNonNull((Object)classInfo, (String)"classInfo");
                Class<?> beanClass = classInfo.getBeanClass();
                AbstractBeanBuilder.this.createInstanceForClass(classInfo, beanClass, model, UpdateSource.OTHER);
            }
        });
    }

    @Override
    public <T> T create(Class<T> beanClass) {
        ClassInfo classInfo = this.classRepository.getOrCreateClassInfo(beanClass);
        PresentationModel model = this.buildPresentationModel(classInfo);
        return this.createInstanceForClass(classInfo, beanClass, model, UpdateSource.SELF);
    }

    private <T> T createInstanceForClass(ClassInfo classInfo, Class<T> beanClass, PresentationModel model, UpdateSource source) {
        Assert.requireNonNull(beanClass, (String)"beanClass");
        try {
            T bean = beanClass.newInstance();
            this.setupProperties(classInfo, bean, model);
            this.setupObservableLists(classInfo, bean, model);
            this.beanRepository.registerBean(bean, model, source);
            return bean;
        }
        catch (Exception e) {
            throw new DolphinRuntimeException("Cannot create bean of type " + beanClass, (Throwable)e);
        }
    }

    private PresentationModel buildPresentationModel(ClassInfo classInfo) {
        try {
            Assert.requireNonNull((Object)classInfo, (String)"classInfo");
            final PresentationModelBuilder builder = this.builderFactory.createBuilder().withType(classInfo.getModelType());
            classInfo.forEachProperty(new ClassInfo.PropertyIterator(){

                @Override
                public void call(PropertyInfo propertyInfo) {
                    Assert.requireNonNull((Object)propertyInfo, (String)"propertyInfo");
                    builder.withAttribute(propertyInfo.getAttributeName());
                }
            });
            return builder.create();
        }
        catch (Exception e) {
            throw new DolphinRuntimeException("Cannot create presentation model for type " + classInfo.getBeanClass(), (Throwable)e);
        }
    }

    private void setupProperties(ClassInfo classInfo, final Object bean, final PresentationModel model) {
        Assert.requireNonNull((Object)classInfo, (String)"classInfo");
        Assert.requireNonNull((Object)model, (String)"model");
        classInfo.forEachProperty(new ClassInfo.PropertyIterator(){

            @Override
            public void call(PropertyInfo propertyInfo) {
                try {
                    Assert.requireNonNull((Object)propertyInfo, (String)"propertyInfo");
                    Object attribute = model.getAttribute(propertyInfo.getAttributeName());
                    Property property = AbstractBeanBuilder.this.create((Attribute)attribute, propertyInfo);
                    propertyInfo.setPriviliged(bean, property);
                }
                catch (Exception e) {
                    throw new DolphinRuntimeException("Can not create property " + propertyInfo.getAttributeName(), (Throwable)e);
                }
            }
        });
    }

    private void setupObservableLists(ClassInfo classInfo, final Object bean, final PresentationModel model) {
        Assert.requireNonNull((Object)classInfo, (String)"classInfo");
        classInfo.forEachObservableList(new ClassInfo.PropertyIterator(){

            @Override
            public void call(PropertyInfo observableListInfo) {
                try {
                    Assert.requireNonNull((Object)observableListInfo, (String)"observableListInfo");
                    ObservableList observableList = AbstractBeanBuilder.this.create(observableListInfo, model, AbstractBeanBuilder.this.listMapper);
                    observableListInfo.setPriviliged(bean, observableList);
                }
                catch (Exception e) {
                    throw new DolphinRuntimeException("Can not create observable list " + observableListInfo.getAttributeName(), (Throwable)e);
                }
            }
        });
    }

    protected abstract <T> ObservableList<T> create(PropertyInfo var1, PresentationModel var2, ListMapper var3);

    protected abstract <T> Property<T> create(Attribute var1, PropertyInfo var2);
}

