/*
 * Decompiled with CFR 0.152.
 */
package com.canoo.dp.impl.remoting;

import com.canoo.platform.core.functional.Subscription;
import com.canoo.platform.remoting.Property;
import com.canoo.platform.remoting.ValueChangeEvent;
import com.canoo.platform.remoting.ValueChangeListener;
import java.util.List;
import java.util.Objects;
import java.util.concurrent.CopyOnWriteArrayList;
import org.apiguardian.api.API;

@API(since="0.x", status=API.Status.INTERNAL)
public abstract class AbstractProperty<T>
implements Property<T> {
    private final List<ValueChangeListener<? super T>> listeners = new CopyOnWriteArrayList<ValueChangeListener<? super T>>();

    @Override
    public Subscription onChanged(final ValueChangeListener<? super T> listener) {
        this.listeners.add(listener);
        return new Subscription(){

            public void unsubscribe() {
                AbstractProperty.this.listeners.remove(listener);
            }
        };
    }

    protected void firePropertyChanged(final T oldValue, final T newValue) {
        ValueChangeEvent event = new ValueChangeEvent<T>(){

            @Override
            public Property<T> getSource() {
                return AbstractProperty.this;
            }

            @Override
            public T getOldValue() {
                return oldValue;
            }

            @Override
            public T getNewValue() {
                return newValue;
            }
        };
        this.notifyInternalListeners(event);
        this.notifyExternalListeners(event);
    }

    protected void notifyExternalListeners(ValueChangeEvent<T> event) {
        for (ValueChangeListener<T> listener : this.listeners) {
            listener.valueChanged(event);
        }
    }

    protected void notifyInternalListeners(ValueChangeEvent<T> event) {
    }

    public String toString() {
        return "Dolphin " + this.getClass().getSimpleName() + "[value: " + this.get() + "]";
    }

    public int hashCode() {
        return Objects.hash(this.get());
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        AbstractProperty that = (AbstractProperty)o;
        return Objects.equals(this.get(), that.get());
    }
}

