/*
 * Decompiled with CFR 0.152.
 */
package com.canoo.dp.impl.remoting;

import com.canoo.dp.impl.platform.core.Assert;
import com.canoo.dp.impl.remoting.BeanAddedListener;
import com.canoo.dp.impl.remoting.BeanBuilder;
import com.canoo.dp.impl.remoting.BeanRepository;
import com.canoo.dp.impl.remoting.DolphinUtils;
import com.canoo.platform.core.functional.Subscription;
import com.canoo.platform.remoting.BeanManager;
import java.util.List;
import org.apiguardian.api.API;

@API(since="0.x", status=API.Status.INTERNAL)
public class BeanManagerImpl
implements BeanManager {
    protected final BeanRepository beanRepository;
    private final BeanBuilder beanBuilder;

    public BeanManagerImpl(BeanRepository beanRepository, BeanBuilder beanBuilder) {
        this.beanRepository = (BeanRepository)Assert.requireNonNull((Object)beanRepository, (String)"beanRepository");
        this.beanBuilder = (BeanBuilder)Assert.requireNonNull((Object)beanBuilder, (String)"beanBuilder");
    }

    @Override
    public <T> T create(Class<T> beanClass) {
        DolphinUtils.assertIsDolphinBean(beanClass);
        return this.beanBuilder.create(beanClass);
    }

    @Override
    public <T> List<T> findAll(Class<T> beanClass) {
        DolphinUtils.assertIsDolphinBean(beanClass);
        return this.beanRepository.findAll(beanClass);
    }

    @Override
    public <T> Subscription onAdded(Class<T> beanClass, BeanAddedListener<? super T> listener) {
        DolphinUtils.assertIsDolphinBean(beanClass);
        return this.beanRepository.addOnAddedListener(beanClass, listener);
    }
}

