/*
 * Decompiled with CFR 0.152.
 */
package com.canoo.dp.impl.remoting;

import com.canoo.dp.impl.platform.core.Assert;
import com.canoo.dp.impl.remoting.BeanAddedListener;
import com.canoo.dp.impl.remoting.BeanRemovedListener;
import com.canoo.dp.impl.remoting.BeanRepository;
import com.canoo.dp.impl.remoting.DolphinUtils;
import com.canoo.dp.impl.remoting.EventDispatcher;
import com.canoo.dp.impl.remoting.UpdateSource;
import com.canoo.dp.impl.remoting.legacy.core.ModelStore;
import com.canoo.dp.impl.remoting.legacy.core.PresentationModel;
import com.canoo.platform.core.functional.Subscription;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.IdentityHashMap;
import java.util.List;
import java.util.Map;
import org.apiguardian.api.API;

@API(since="0.x", status=API.Status.INTERNAL)
public class BeanRepositoryImpl
implements BeanRepository {
    private final Map<Object, PresentationModel> objectPmToDolphinPm = new IdentityHashMap<Object, PresentationModel>();
    private final Map<String, Object> dolphinIdToObjectPm = new HashMap<String, Object>();
    private final ModelStore modelStore;
    private final Map<Class<?>, List<BeanAddedListener<?>>> beanAddedListenerMap = new HashMap();
    private List<BeanAddedListener<Object>> anyBeanAddedListeners = new ArrayList<BeanAddedListener<Object>>();
    private final Map<Class<?>, List<BeanRemovedListener<?>>> beanRemovedListenerMap = new HashMap();
    private List<BeanRemovedListener<Object>> anyBeanRemovedListeners = new ArrayList<BeanRemovedListener<Object>>();

    public BeanRepositoryImpl(ModelStore modelStore, EventDispatcher dispatcher) {
        this.modelStore = (ModelStore)Assert.requireNonNull((Object)modelStore, (String)"modelStore");
        dispatcher.addRemovedHandler(model -> {
            Object bean = this.dolphinIdToObjectPm.remove(model.getId());
            if (bean != null) {
                this.objectPmToDolphinPm.remove(bean);
                if (this.beanRemovedListenerMap.containsKey(bean.getClass())) {
                    for (BeanRemovedListener<Object> beanRemovedListener : this.beanRemovedListenerMap.get(bean.getClass())) {
                        beanRemovedListener.beanDestructed(bean);
                    }
                }
                for (BeanRemovedListener<Object> beanRemovedListener : this.anyBeanRemovedListeners) {
                    beanRemovedListener.beanDestructed(bean);
                }
            }
        });
    }

    @Override
    public <T> Subscription addOnAddedListener(Class<T> beanClass, BeanAddedListener<? super T> listener) {
        DolphinUtils.assertIsDolphinBean(beanClass);
        this.beanAddedListenerMap.computeIfAbsent(beanClass, s -> new ArrayList()).add(listener);
        return () -> {
            if (this.beanAddedListenerMap.containsKey(beanClass)) {
                this.beanAddedListenerMap.get(beanClass).remove(listener);
            }
        };
    }

    @Override
    public Subscription addOnAddedListener(BeanAddedListener<Object> listener) {
        this.anyBeanAddedListeners.add(listener);
        return () -> this.anyBeanAddedListeners.remove(listener);
    }

    @Override
    public <T> Subscription addOnRemovedListener(Class<T> beanClass, BeanRemovedListener<? super T> listener) {
        DolphinUtils.assertIsDolphinBean(beanClass);
        this.beanRemovedListenerMap.computeIfAbsent(beanClass, s -> new ArrayList()).add(listener);
        return () -> {
            if (this.beanRemovedListenerMap.containsKey(beanClass)) {
                this.beanRemovedListenerMap.get(beanClass).remove(listener);
            }
        };
    }

    @Override
    public Subscription addOnRemovedListener(BeanRemovedListener<Object> listener) {
        this.anyBeanRemovedListeners.add(listener);
        return () -> this.anyBeanRemovedListeners.remove(listener);
    }

    @Override
    public boolean isManaged(Object bean) {
        DolphinUtils.assertIsDolphinBean(bean);
        return this.objectPmToDolphinPm.containsKey(bean);
    }

    @Override
    public <T> void delete(T bean) {
        DolphinUtils.assertIsDolphinBean(bean);
        PresentationModel model = this.objectPmToDolphinPm.remove(bean);
        if (model != null) {
            this.dolphinIdToObjectPm.remove(model.getId());
            this.modelStore.remove(model);
        }
    }

    @Override
    public <T> List<T> findAll(Class<T> beanClass) {
        DolphinUtils.assertIsDolphinBean(beanClass);
        ArrayList<Object> result = new ArrayList<Object>();
        List presentationModels = this.modelStore.findAllPresentationModelsByType(DolphinUtils.getDolphinPresentationModelTypeForClass(beanClass));
        for (PresentationModel model : presentationModels) {
            result.add(this.dolphinIdToObjectPm.get(model.getId()));
        }
        return result;
    }

    @Override
    public Object getBean(String sourceId) {
        if (sourceId == null) {
            return null;
        }
        if (!this.dolphinIdToObjectPm.containsKey(sourceId)) {
            throw new IllegalArgumentException("No bean instance found with id " + sourceId);
        }
        return this.dolphinIdToObjectPm.get(sourceId);
    }

    @Override
    public String getDolphinId(Object bean) {
        if (bean == null) {
            return null;
        }
        DolphinUtils.assertIsDolphinBean(bean);
        try {
            return this.objectPmToDolphinPm.get(bean).getId();
        }
        catch (NullPointerException ex) {
            throw new IllegalArgumentException("Only managed Dolphin Beans can be used.", ex);
        }
    }

    @Override
    public void registerBean(Object bean, PresentationModel model, UpdateSource source) {
        DolphinUtils.assertIsDolphinBean(bean);
        this.objectPmToDolphinPm.put(bean, model);
        this.dolphinIdToObjectPm.put(model.getId(), bean);
        if (source == UpdateSource.OTHER) {
            if (this.beanAddedListenerMap.containsKey(bean.getClass())) {
                for (BeanAddedListener<Object> beanAddedListener : this.beanAddedListenerMap.get(bean.getClass())) {
                    beanAddedListener.beanCreated(bean);
                }
            }
            for (BeanAddedListener<Object> beanAddedListener : this.anyBeanAddedListeners) {
                beanAddedListener.beanCreated(bean);
            }
        }
    }
}

