/*
 * Decompiled with CFR 0.152.
 */
package com.canoo.dp.impl.remoting;

import com.canoo.dp.impl.platform.core.Assert;
import com.canoo.dp.impl.platform.core.ReflectionHelper;
import com.canoo.dp.impl.remoting.ClassPropertyInfo;
import com.canoo.dp.impl.remoting.ClassRepository;
import com.canoo.dp.impl.remoting.Converters;
import com.canoo.dp.impl.remoting.DolphinUtils;
import com.canoo.dp.impl.remoting.MappingException;
import com.canoo.dp.impl.remoting.PresentationModelBuilder;
import com.canoo.dp.impl.remoting.PresentationModelBuilderFactory;
import com.canoo.dp.impl.remoting.info.ClassInfo;
import com.canoo.dp.impl.remoting.info.PropertyInfo;
import com.canoo.dp.impl.remoting.legacy.core.ModelStore;
import com.canoo.dp.impl.remoting.legacy.core.ModelStoreEvent;
import com.canoo.dp.impl.remoting.legacy.core.ModelStoreListener;
import com.canoo.platform.remoting.ObservableList;
import com.canoo.platform.remoting.Property;
import com.canoo.platform.remoting.spi.converter.Converter;
import java.lang.reflect.Field;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Map;
import org.apiguardian.api.API;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@API(since="0.x", status=API.Status.INTERNAL)
public class ClassRepositoryImpl
implements ClassRepository {
    private static final Logger LOG = LoggerFactory.getLogger(ClassRepositoryImpl.class);
    private final PresentationModelBuilderFactory builderFactory;
    private final Converters converters;
    private final Map<Class<?>, ClassInfo> classToClassInfoMap = new HashMap();
    private final Map<String, ClassInfo> modelTypeToClassInfoMap = new HashMap<String, ClassInfo>();

    public ClassRepositoryImpl(ModelStore modelStore, Converters converters, PresentationModelBuilderFactory builderFactory) {
        this.converters = (Converters)Assert.requireNonNull((Object)converters, (String)"converters");
        this.builderFactory = (PresentationModelBuilderFactory)Assert.requireNonNull((Object)builderFactory, (String)"builderFactory");
        ((ModelStore)Assert.requireNonNull((Object)modelStore, (String)"modelStore")).addModelStoreListener("@@@ DOLPHIN_BEAN @@@", new ModelStoreListener(){

            public void modelStoreChanged(ModelStoreEvent event) {
                Assert.requireNonNull((Object)event, (String)"event");
                try {
                    String className = (String)event.getPresentationModel().getAttribute("@@@ JAVA_CLASS @@@").getValue();
                    Class<?> beanClass = Class.forName(className);
                    ClassInfo classInfo = ClassRepositoryImpl.this.createClassInfoForClass(beanClass);
                    Assert.requireNonNull((Object)classInfo, (String)"classInfo");
                    ClassRepositoryImpl.this.classToClassInfoMap.put(beanClass, classInfo);
                    ClassRepositoryImpl.this.modelTypeToClassInfoMap.put(classInfo.getModelType(), classInfo);
                }
                catch (ClassNotFoundException e) {
                    throw new RuntimeException("Error in class info generation!", e);
                }
            }
        });
    }

    @Override
    public ClassInfo getClassInfo(String modelType) {
        return this.modelTypeToClassInfoMap.get(modelType);
    }

    @Override
    public ClassInfo getOrCreateClassInfo(Class<?> beanClass) {
        ClassInfo existingClassInfo = this.classToClassInfoMap.get(beanClass);
        if (existingClassInfo != null) {
            return existingClassInfo;
        }
        this.createPresentationModelForClass(beanClass);
        return this.classToClassInfoMap.get(beanClass);
    }

    private void createPresentationModelForClass(Class<?> beanClass) {
        Assert.requireNonNull(beanClass, (String)"beanClass");
        String id = DolphinUtils.getDolphinPresentationModelTypeForClass(beanClass);
        PresentationModelBuilder builder = this.builderFactory.createBuilder().withId(id).withType("@@@ DOLPHIN_BEAN @@@").withAttribute("@@@ JAVA_CLASS @@@", beanClass.getName());
        for (Field field : ReflectionHelper.getInheritedDeclaredFields(beanClass)) {
            if (!Property.class.isAssignableFrom(field.getType()) && !ObservableList.class.isAssignableFrom(field.getType())) continue;
            String attributeName = DolphinUtils.getDolphinAttributePropertyNameForField(field);
            Class clazz = ReflectionHelper.getTypeParameter((Field)field);
            if (clazz == null) {
                throw new MappingException("Can't define generic type for field " + attributeName + " in bean " + beanClass);
            }
            int type = this.converters.getFieldType(clazz);
            builder.withAttribute(attributeName, type);
        }
        builder.create();
    }

    private ClassInfo createClassInfoForClass(Class<?> beanClass) {
        ArrayList<PropertyInfo> propertyInfos = new ArrayList<PropertyInfo>();
        ArrayList<PropertyInfo> observableListInfos = new ArrayList<PropertyInfo>();
        for (Field field : ReflectionHelper.getInheritedDeclaredFields(beanClass)) {
            PropertyType type = null;
            if (Property.class.isAssignableFrom(field.getType())) {
                type = PropertyType.PROPERTY;
            } else if (ObservableList.class.isAssignableFrom(field.getType())) {
                type = PropertyType.OBSERVABLE_LIST;
            }
            Class parameterType = ReflectionHelper.getTypeParameter((Field)field);
            if (type == null || parameterType == null) continue;
            String attributeName = DolphinUtils.getDolphinAttributePropertyNameForField(field);
            Converter converter = this.converters.getConverter(parameterType);
            ClassPropertyInfo propertyInfo = new ClassPropertyInfo(attributeName, converter, field);
            if (type == PropertyType.PROPERTY) {
                propertyInfos.add(propertyInfo);
                continue;
            }
            observableListInfos.add(propertyInfo);
        }
        return new ClassInfo(beanClass, propertyInfos, observableListInfos);
    }

    private static enum PropertyType {
        PROPERTY,
        OBSERVABLE_LIST;

    }
}

