/*
 * Decompiled with CFR 0.152.
 */
package com.canoo.dp.impl.remoting;

import com.canoo.dp.impl.platform.core.Assert;
import com.canoo.dp.impl.remoting.BeanRepository;
import com.canoo.platform.core.DolphinRuntimeException;
import com.canoo.platform.remoting.spi.converter.Converter;
import com.canoo.platform.remoting.spi.converter.ConverterFactory;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Iterator;
import java.util.List;
import java.util.ServiceLoader;
import org.apiguardian.api.API;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@API(since="0.x", status=API.Status.INTERNAL)
public class Converters {
    private static final Logger LOG = LoggerFactory.getLogger(Converters.class);
    private final List<ConverterFactory> converterFactories = new ArrayList<ConverterFactory>();

    public Converters(BeanRepository beanRepository) {
        ServiceLoader<ConverterFactory> loader = ServiceLoader.load(ConverterFactory.class);
        loader.reload();
        for (ConverterFactory factory : loader) {
            LOG.trace("Found converter factory {} with type identifier {}", factory.getClass(), (Object)factory.getTypeIdentifier());
            if (!this.isTypeAlreadyAdded(factory) && !this.isAnyConversionTypeAlreadyAdded(factory)) {
                factory.init(beanRepository);
                this.converterFactories.add(factory);
                continue;
            }
            throw new DolphinRuntimeException("Converter of type(s) " + Arrays.toString(factory.getSupportedTypes().toArray()) + " already added to the factory.");
        }
    }

    private boolean isTypeAlreadyAdded(ConverterFactory converterFactory) {
        Assert.requireNonNull((Object)converterFactory, (String)"converterFactory");
        for (ConverterFactory factory : this.converterFactories) {
            if (factory.getTypeIdentifier() != converterFactory.getTypeIdentifier()) continue;
            return true;
        }
        return false;
    }

    private boolean isAnyConversionTypeAlreadyAdded(ConverterFactory converterFactory) {
        Assert.requireNonNull((Object)converterFactory, (String)"converterFactory");
        Iterator<ConverterFactory> iterator = this.converterFactories.iterator();
        if (iterator.hasNext()) {
            ConverterFactory factory = iterator.next();
            return factory.getSupportedTypes().stream().filter(type -> converterFactory.getSupportedTypes().contains(type)).findAny().map(c -> true).orElse(false);
        }
        return false;
    }

    public int getFieldType(Class<?> clazz) {
        return this.getFactory(clazz).getTypeIdentifier();
    }

    public Converter getConverter(Class<?> clazz) {
        return this.getFactory(clazz).getConverterForType(clazz);
    }

    private ConverterFactory getFactory(Class<?> clazz) {
        Assert.requireNonNull(clazz, (String)"clazz");
        ArrayList<ConverterFactory> foundConverters = new ArrayList<ConverterFactory>();
        for (ConverterFactory factory : this.converterFactories) {
            if (!factory.supportsType(clazz)) continue;
            foundConverters.add(factory);
        }
        if (foundConverters.size() > 1) {
            throw new RuntimeException("More than 1 converter instance found to convert " + clazz);
        }
        if (foundConverters.isEmpty()) {
            throw new RuntimeException("No converter instance found to convert " + clazz);
        }
        return (ConverterFactory)foundConverters.get(0);
    }
}

