/*
 * Decompiled with CFR 0.152.
 */
package com.canoo.dp.impl.remoting;

import com.canoo.dp.impl.platform.core.Assert;
import com.canoo.dp.impl.remoting.BeanDefinitionException;
import com.canoo.platform.remoting.ObservableList;
import com.canoo.platform.remoting.Property;
import com.canoo.platform.remoting.RemotingBean;
import java.beans.PropertyDescriptor;
import java.lang.reflect.Field;
import org.apiguardian.api.API;

@API(since="0.x", status=API.Status.INTERNAL)
public class DolphinUtils {
    private DolphinUtils() {
    }

    public static String getDolphinAttributePropertyNameForField(Field propertyField) {
        return propertyField.getName();
    }

    public static String getDolphinPresentationModelTypeForClass(Class<?> beanClass) {
        return DolphinUtils.assertIsDolphinBean(beanClass).getName();
    }

    public static <T> T assertIsDolphinBean(T bean) {
        Assert.requireNonNull(bean, (String)"bean");
        DolphinUtils.assertIsDolphinBean(bean.getClass());
        return bean;
    }

    public static <T> Class<T> assertIsDolphinBean(Class<T> beanClass) {
        if (!DolphinUtils.isDolphinBean(beanClass)) {
            throw new BeanDefinitionException(beanClass);
        }
        return beanClass;
    }

    public static boolean isDolphinBean(Class<?> beanClass) {
        Assert.requireNonNull(beanClass, (String)"beanClass");
        return beanClass.isAnnotationPresent(RemotingBean.class);
    }

    public static boolean isEnumType(Class<?> cls) {
        Assert.requireNonNull(cls, (String)"cls");
        return cls.isEnum();
    }

    public static boolean isAllowedForUnmanaged(Class<?> cls) {
        return DolphinUtils.isBasicType(cls) || DolphinUtils.isProperty(cls) || DolphinUtils.isEnumType(cls);
    }

    public static boolean isProperty(PropertyDescriptor descriptor) {
        Assert.requireNonNull((Object)descriptor, (String)"descriptor");
        return DolphinUtils.isProperty(descriptor.getPropertyType());
    }

    public static boolean isProperty(Class<?> propertyType) {
        return Property.class.isAssignableFrom(propertyType);
    }

    public static boolean isObservableList(Class<?> propertyType) {
        return ObservableList.class.isAssignableFrom(propertyType);
    }

    public static boolean isBasicType(Class<?> cls) {
        Assert.requireNonNull(cls, (String)"cls");
        return cls.isPrimitive() || cls.equals(String.class) || cls.equals(Boolean.class) || cls.equals(Byte.class) || Number.class.isAssignableFrom(cls);
    }
}

