/*
 * Decompiled with CFR 0.152.
 */
package com.canoo.dp.impl.remoting;

import com.canoo.dp.impl.platform.core.Assert;
import com.canoo.dp.impl.remoting.DolphinEventHandler;
import com.canoo.dp.impl.remoting.EventDispatcher;
import com.canoo.dp.impl.remoting.legacy.core.ModelStore;
import com.canoo.dp.impl.remoting.legacy.core.ModelStoreEvent;
import com.canoo.dp.impl.remoting.legacy.core.PresentationModel;
import java.util.ArrayList;
import java.util.List;
import org.apiguardian.api.API;

@API(since="0.x", status=API.Status.INTERNAL)
public abstract class EventDispatcherImpl
implements EventDispatcher {
    private final List<DolphinEventHandler> modelAddedHandlers = new ArrayList<DolphinEventHandler>(1);
    private final List<DolphinEventHandler> modelRemovedHandlers = new ArrayList<DolphinEventHandler>(1);
    private final List<DolphinEventHandler> listSpliceHandlers = new ArrayList<DolphinEventHandler>(1);
    private final List<DolphinEventHandler> controllerActionCallBeanAddedHandlers = new ArrayList<DolphinEventHandler>(1);
    private final List<DolphinEventHandler> controllerActionCallBeanRemovedHandlers = new ArrayList<DolphinEventHandler>(1);
    private final List<DolphinEventHandler> internalAttributesBeanAddedHandlers = new ArrayList<DolphinEventHandler>(1);

    public EventDispatcherImpl(ModelStore modelStore) {
        ((ModelStore)Assert.requireNonNull((Object)modelStore, (String)"modelStore")).addModelStoreListener(this);
    }

    @Override
    public void addAddedHandler(DolphinEventHandler handler) {
        this.modelAddedHandlers.add(handler);
    }

    @Override
    public void addRemovedHandler(DolphinEventHandler handler) {
        this.modelRemovedHandlers.add(handler);
    }

    @Override
    public void addListSpliceHandler(DolphinEventHandler handler) {
        this.listSpliceHandlers.add(handler);
    }

    @Override
    public void addControllerActionCallBeanAddedHandler(DolphinEventHandler handler) {
        this.controllerActionCallBeanAddedHandlers.add(handler);
    }

    @Override
    public void addControllerActionCallBeanRemovedHandler(DolphinEventHandler handler) {
        this.controllerActionCallBeanRemovedHandlers.add(handler);
    }

    @Override
    public void onceInternalAttributesBeanAddedHandler(DolphinEventHandler handler) {
        this.internalAttributesBeanAddedHandlers.add(handler);
    }

    public void modelStoreChanged(ModelStoreEvent event) {
        Assert.requireNonNull((Object)event, (String)"event");
        Object model = event.getPresentationModel();
        if (!this.isLocalChange((PresentationModel)model)) {
            if (ModelStoreEvent.Type.ADDED == event.getType()) {
                this.onAddedHandler((PresentationModel)model);
            } else if (ModelStoreEvent.Type.REMOVED == event.getType()) {
                this.onRemovedHandler((PresentationModel)model);
            }
        }
    }

    private void onAddedHandler(PresentationModel model) {
        String type;
        Assert.requireNonNull((Object)model, (String)"model");
        switch (type = model.getPresentationModelType()) {
            case "@@@ DOLPHIN_BEAN @@@": {
                break;
            }
            case "@@@ CONTROLLER_ACTION_CALL_BEAN @@@": {
                for (DolphinEventHandler handler : this.controllerActionCallBeanAddedHandlers) {
                    handler.onEvent(model);
                }
                break;
            }
            case "@@@ HIGHLANDER_BEAN @@@": {
                for (DolphinEventHandler handler : this.internalAttributesBeanAddedHandlers) {
                    handler.onEvent(model);
                }
                this.internalAttributesBeanAddedHandlers.clear();
                break;
            }
            case "@DP:LS@": {
                for (DolphinEventHandler handler : this.listSpliceHandlers) {
                    handler.onEvent(model);
                }
                break;
            }
            default: {
                for (DolphinEventHandler handler : this.modelAddedHandlers) {
                    handler.onEvent(model);
                }
            }
        }
    }

    private void onRemovedHandler(PresentationModel model) {
        String type;
        Assert.requireNonNull((Object)model, (String)"model");
        switch (type = model.getPresentationModelType()) {
            case "@@@ DOLPHIN_BEAN @@@": 
            case "@DP:LS@": 
            case "@@@ HIGHLANDER_BEAN @@@": {
                break;
            }
            case "@@@ CONTROLLER_ACTION_CALL_BEAN @@@": {
                for (DolphinEventHandler handler : this.controllerActionCallBeanRemovedHandlers) {
                    handler.onEvent(model);
                }
                break;
            }
            default: {
                for (DolphinEventHandler handler : this.modelRemovedHandlers) {
                    handler.onEvent(model);
                }
            }
        }
    }

    private boolean isLocalChange(PresentationModel model) {
        Assert.requireNonNull((Object)model, (String)"model");
        Object value = model.getAttribute("@@@ SOURCE_SYSTEM @@@").getValue();
        return this.getLocalSystemIdentifier().equals(value);
    }

    public abstract String getLocalSystemIdentifier();
}

