/*
 * Decompiled with CFR 0.152.
 */
package com.canoo.dp.impl.remoting;

import com.canoo.dp.impl.platform.core.Assert;
import com.canoo.dp.impl.remoting.BeanRepository;
import com.canoo.dp.impl.remoting.PresentationModelBuilder;
import com.canoo.dp.impl.remoting.legacy.core.Attribute;
import com.canoo.dp.impl.remoting.legacy.core.PresentationModel;
import org.apiguardian.api.API;

@API(since="0.x", status=API.Status.INTERNAL)
public class InternalAttributesBean {
    private static final String CONTROLLER_NAME = "controllerName";
    private static final String CONTROLLER_ID = "controllerId";
    private static final String MODEL = "model";
    private final BeanRepository beanRepository;
    private final Attribute controllerNameAttribute;
    private final Attribute controllerIdAttribute;
    private final Attribute modelAttribute;

    public InternalAttributesBean(BeanRepository beanRepository, PresentationModel pm) {
        this.beanRepository = (BeanRepository)Assert.requireNonNull((Object)beanRepository, (String)"beanRepository");
        Assert.requireNonNull((Object)pm, (String)"pm");
        this.controllerNameAttribute = pm.getAttribute(CONTROLLER_NAME);
        this.controllerIdAttribute = pm.getAttribute(CONTROLLER_ID);
        this.modelAttribute = pm.getAttribute(MODEL);
    }

    public InternalAttributesBean(BeanRepository beanRepository, PresentationModelBuilder builder) {
        this(beanRepository, (PresentationModel)((PresentationModelBuilder)Assert.requireNonNull((Object)builder, (String)"builder")).withType("@@@ HIGHLANDER_BEAN @@@").withAttribute(CONTROLLER_NAME).withAttribute(CONTROLLER_ID).withAttribute(MODEL).create());
    }

    public String getControllerName() {
        return (String)this.controllerNameAttribute.getValue();
    }

    public void setControllerName(String controllerName) {
        this.controllerNameAttribute.setValue(controllerName);
    }

    public String getControllerId() {
        return (String)this.controllerIdAttribute.getValue();
    }

    public void setControllerId(String controllerId) {
        this.controllerIdAttribute.setValue(controllerId);
    }

    public <T> T getModel() {
        if (this.modelAttribute.getValue() == null) {
            throw new RuntimeException("Dolphin Platform internal error: No model defined");
        }
        return (T)this.beanRepository.getBean(this.modelAttribute.getValue().toString());
    }

    public void setModel(Object model) {
        this.modelAttribute.setValue(this.beanRepository.getDolphinId(model));
    }
}

