/*
 * Decompiled with CFR 0.152.
 */
package com.canoo.dp.impl.remoting;

import com.canoo.dp.impl.platform.core.Assert;
import com.canoo.dp.impl.remoting.AbstractProperty;
import com.canoo.dp.impl.remoting.MappingException;
import com.canoo.dp.impl.remoting.info.PropertyInfo;
import com.canoo.dp.impl.remoting.legacy.core.Attribute;
import com.canoo.platform.remoting.ValueChangeListener;
import com.canoo.platform.remoting.spi.converter.ValueConverterException;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.util.List;
import java.util.concurrent.CopyOnWriteArrayList;
import org.apiguardian.api.API;

@API(since="0.x", status=API.Status.INTERNAL)
public class PropertyImpl<T>
extends AbstractProperty<T> {
    private final Attribute attribute;
    private final PropertyInfo propertyInfo;
    private final List<ValueChangeListener<? super T>> listeners = new CopyOnWriteArrayList<ValueChangeListener<? super T>>();

    public PropertyImpl(final Attribute attribute, final PropertyInfo propertyInfo) {
        this.attribute = (Attribute)Assert.requireNonNull((Object)attribute, (String)"attribute");
        this.propertyInfo = (PropertyInfo)Assert.requireNonNull((Object)propertyInfo, (String)"propertyInfo");
        attribute.addPropertyChangeListener("value", new PropertyChangeListener(){

            @Override
            public void propertyChange(PropertyChangeEvent evt) {
                Assert.requireNonNull((Object)evt, (String)"evt");
                try {
                    Object oldValue = PropertyImpl.this.propertyInfo.convertFromDolphin(evt.getOldValue());
                    Object newValue = PropertyImpl.this.propertyInfo.convertFromDolphin(evt.getNewValue());
                    if (oldValue == null && newValue != null || oldValue != null && newValue == null || oldValue != null && newValue != null && !oldValue.equals(newValue)) {
                        PropertyImpl.this.firePropertyChanged(oldValue, newValue);
                    }
                }
                catch (Exception e) {
                    throw new MappingException("Error in property change handling for property: " + attribute.getPropertyName() + " in attribute with name: " + propertyInfo.getAttributeName() + " and Id: " + attribute.getId(), e);
                }
            }
        });
    }

    @Override
    public void set(T value) {
        try {
            this.attribute.setValue(this.propertyInfo.convertToDolphin(value));
        }
        catch (ValueConverterException e) {
            throw new MappingException("Error in mutating property value!", e);
        }
    }

    @Override
    public T get() {
        try {
            return (T)this.propertyInfo.convertFromDolphin(this.attribute.getValue());
        }
        catch (ValueConverterException e) {
            throw new MappingException("Error in accessing property value!", e);
        }
    }
}

